enum List {
    Cons(i32, Rc<List>),
    Nil,
}

use crate::List::{Cons, Nil};
use std::rc::Rc;

// ANCHOR: here
fn main() {
    let a = Rc::new(Cons(5, Rc::new(Cons(10, Rc::new(Nil)))));
    println!("licznik po utworzeniu a = {}", Rc::strong_count(&a));
    let b = Cons(3, Rc::clone(&a));
    println!("licznik po utworzeniu b = {}", Rc::strong_count(&a));
    {
        let c = Cons(4, Rc::clone(&a));
        println!("licznik po utworzeniu c = {}", Rc::strong_count(&a));
    }
    println!("licznik po wyjciu c poza zakres = {}", Rc::strong_count(&a));
}
// ANCHOR_END: here
