use std::sync::mpsc;
use std::thread;
use std::time::Duration;

fn main() {
    // ANCHOR: here
    // --fragment pominity--

    let (tx, rx) = mpsc::channel();

    let tx1 = tx.clone();
    thread::spawn(move || {
        let vals = vec![
            String::from("pozdrowienia"),
            String::from("z"),
            String::from("tego"),
            String::from("wtku"),
        ];

        for val in vals {
            tx1.send(val).unwrap();
            thread::sleep(Duration::from_secs(1));
        }
    });

    thread::spawn(move || {
        let vals = vec![
            String::from("wicej"),
            String::from("komunikatw"),
            String::from("dla"),
            String::from("ciebie"),
        ];

        for val in vals {
            tx.send(val).unwrap();
            thread::sleep(Duration::from_secs(1));
        }
    });

    for received in rx {
        println!("Otrzymano: {}", received);
    }

    // --fragment pominity--
    // ANCHOR_END: here
}
