// ANCHOR: here
use std::env;
use std::process;

use minigrep::Config;

fn main() {
    // --fragment pominity--
    // ANCHOR_END: here
    let args: Vec<String> = env::args().collect();

    let config = Config::build(&args).unwrap_or_else(|err| {
        println!("Problem z parsowaniem argumentw: {err}");
        process::exit(1);
    });

    println!("Wyszukiwanie {}", config.query);
    println!("W pliku {}", config.file_path);

    // ANCHOR: here
    if let Err(e) = minigrep::run(config) {
        // --fragment pominity--
        // ANCHOR_END: here
        println!("Bd aplikacji: {e}");
        process::exit(1);
        // ANCHOR: here
    }
}
// ANCHOR_END: here
