// ANCHOR: here
use std::{
    sync::{mpsc, Arc, Mutex},
    thread,
};
// --fragment pominity--

// ANCHOR_END: here
pub struct ThreadPool {
    workers: Vec<Worker>,
    sender: mpsc::Sender<Job>,
}

struct Job;

// ANCHOR: here
impl ThreadPool {
    // --fragment pominity--
    // ANCHOR_END: here
    /// Tworzy now instancj ThreadPool.
    ///
    /// size to liczba watkw w puli.
    ///
    /// # Panikuje
    ///
    /// Funkcja `new` wywoa panik, jeli size bdzie rwny 0.
    // ANCHOR: here
    pub fn new(size: usize) -> ThreadPool {
        assert!(size > 0);

        let (sender, receiver) = mpsc::channel();

        let receiver = Arc::new(Mutex::new(receiver));

        let mut workers = Vec::with_capacity(size);

        for id in 0..size {
            workers.push(Worker::new(id, Arc::clone(&receiver)));
        }

        ThreadPool { workers, sender }
    }

    // --fragment pominity--
    // ANCHOR_END: here

    pub fn execute<F>(&self, f: F)
    where
        F: FnOnce() + Send + 'static,
    {
    }
    // ANCHOR: here
}

// --fragment pominity--

// ANCHOR_END: here
struct Worker {
    id: usize,
    thread: thread::JoinHandle<()>,
}

// ANCHOR: here
impl Worker {
    fn new(id: usize, receiver: Arc<Mutex<mpsc::Receiver<Job>>>) -> Worker {
        // --fragment pominity--
        // ANCHOR_END: here
        let thread = thread::spawn(|| {
            receiver;
        });

        Worker { id, thread }
        // ANCHOR: here
    }
}
// ANCHOR_END: here
