use std::env;
use std::process;

use minigrep::Config;

// ANCHOR: ch13
fn main() {
    let args: Vec<String> = env::args().collect();

    let config = Config::build(&args).unwrap_or_else(|err| {
        eprintln!("Problem z parsowaniem argumentw: {err}");
        process::exit(1);
    });

    // --fragment pominity--
    // ANCHOR_END: r13

    if let Err(e) = minigrep::run(config) {
        eprintln!("Bd aplikacji: {e}");
        process::exit(1);
    }
    // ANCHOR: r13
}
// ANCHOR_END: r13
