use std::env;
use std::fs;

// ANCHOR: here
fn main() {
    let args: Vec<String> = env::args().collect();

    let config = Config::new(&args);
    // ANCHOR_END: here

    println!("Wyszukiwanie {}", config.query);
    println!("W pliku {}", config.file_path);

    let contents = fs::read_to_string(config.file_path)
        .expect("Odczyt pliku powinien by moliwy");

    println!("Z tekstem:\n{contents}");
    // ANCHOR: here

    // --fragment pominity--
}

// --fragment pominity--

// ANCHOR_END: here
struct Config {
    query: String,
    file_path: String,
}

// ANCHOR: here
impl Config {
    fn new(args: &[String]) -> Config {
        let query = args[1].clone();
        let file_path = args[2].clone();

        Config { query, file_path }
    }
}
// ANCHOR_END: here
