using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace CredentialsManagerClient
{
   public partial class LoginDialog : Form
   {
      string m_Url;

      public LoginDialog()
      {
         InitializeComponent();
      }
      public LoginDialog(string url,string application,string user) : this()
      {
         m_Url = url;
         m_ApplicationTextBox.Text = application;
         m_UserNameTextBox.Text = user;
      }

      void OnLogin(object sender,EventArgs e)
      {
         using(UserManagerProxy userManager = new UserManagerProxy(m_Url))
         {
            bool authenticated = false;

            authenticated = userManager.Authenticate(m_ApplicationTextBox.Text,m_UserNameTextBox.Text,m_PasswordTextBox.Text);
            if(authenticated)
            {
               MessageBox.Show(this,"Uwierzytelnianie przebiego pomylnie","Meneder danych uwierzytelniajcych",MessageBoxButtons.OK);
            }
            else
            {
               MessageBox.Show(this,"Nieprawidowe dane uwierzytelniajce","Meneder danych uwierzytelniajcych",MessageBoxButtons.OK,MessageBoxIcon.Hand);
            }
         }
      }

      void OnClose(object sender,EventArgs e)
      {
         Close();
      }
   }
}