//  2011 IDesign Inc.
// Pytania? Komentarze? Odwied
// http://www.idesign.net

using System;
using System.ServiceModel;

[ServiceContract]
public interface IUserManager
{
   /// <summary>
   /// Uwierzytelnia uytkownika.
   /// </summary>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   bool Authenticate(string applicationName,string userName,string password);

   /// <summary>
   /// Sprawdza przynaleno uytkownika do roli.
   /// </summary>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   bool IsInRole(string applicationName,string userName,string role);

   /// <summary>
   /// Zwraca wszystkie role, do ktrych naley dany uytkownik.
   /// </summary>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   string[] GetRoles(string applicationName,string userName);
}