//  2011 IDesign Inc.
// Pytania? Komentarze? Odwied
// http://www.idesign.net

using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Web.Services.Protocols;

namespace CredentialsManagerClient
{
   partial class ResetWithQuestionDialog : Form
   {
      string m_Url;
      string m_Application;
      PasswordManagerProxy m_PasswordManager;

      public ResetWithQuestionDialog(string url,string application,string user)
      {
         InitializeComponent();

         m_Url = url;
         m_Application = application;
         m_UserNameTextBox.Text = user;

         m_PasswordManager = new PasswordManagerProxy(m_Url);
         m_PasswordQuestionTextBox.Text = m_PasswordManager.GetPasswordQuestion(application,user);
      }
      void OnReset(object sender,EventArgs e)
      {
         if(m_PasswordAnswerTextBox.Text == String.Empty && m_PasswordAnswerTextBox.Enabled)
         {
            m_Validator.SetError(m_PasswordAnswerTextBox,"Odpowied nie moe by pusta");
            return;
         }
         m_Validator.Clear();

         string newPassword = null;
         try
         {
            newPassword = m_PasswordManager.ResetPasswordWithQuestionAndAnswer(m_Application,m_UserNameTextBox.Text,m_PasswordAnswerTextBox.Text);
         }
         catch(SoapException exception)
         {
            if(exception.Message.Contains("Podana odpowied jest bdna"))
            {
               MessageBox.Show("Podana odpowied jest bdna. Sprbuj ponownie.","Meneder danych uwierzytelniajcych",MessageBoxButtons.OK,MessageBoxIcon.Error);
               return;
            }
            if(exception.Message.Contains("Konto uytkownika zostao zablokowane"))
            {
               MessageBox.Show("Konto uytkownika zostao zablokowane","Meneder danych uwierzytelniajcych",MessageBoxButtons.OK,MessageBoxIcon.Error);
               Close();
               return;
            }
            
            throw;
         }
         Clipboard.SetText(newPassword);

         MessageBox.Show("Wygenerowane haso: " + newPassword + " " + Environment.NewLine + "Haso jest dostpne take w schowku.","Meneder danych uwierzytelniajcych",MessageBoxButtons.OK,MessageBoxIcon.Information);

         Close();
      }

      void OnClosed(object sender,FormClosedEventArgs e)
      {
         m_PasswordManager.Close();
      }
   }
}