﻿// © 2011 IDesign Inc.
// Pytania? Komentarze? Odwiedź
// http://www.idesign.net

using System;
using System.Diagnostics;
using System.ServiceModel;
using System.Threading;

namespace ServiceModelEx
{
   public static class HostThreadAffinity 
   {
      /// <summary>
      /// Metoda może być wywołana tylko przed otwarciem hosta
      /// </summary>
      public static void SetThreadAffinity(this ServiceHost host,string threadName)
      {
         if(host.State == CommunicationState.Opened)
         {
            throw new InvalidOperationException("Host jest już otwarty");
         }

         Debug.Assert(SynchronizationContext.Current == null); // Metodę można wywołać tylko raz

         AffinitySynchronizer affinitySynchronizer = new AffinitySynchronizer(threadName);
         SynchronizationContext.SetSynchronizationContext(affinitySynchronizer);

         host.Closing += delegate
                         {
                            using(affinitySynchronizer)
                            {}
                         };
      }
      /// <summary>
      /// Metoda może być wywołana tylko przed otwarciem hosta
      /// </summary>
      public static void SetThreadAffinity(this ServiceHost host)
      {
         SetThreadAffinity(host,"Wykonywanie wszystkich punktów końcowych " + host.Description.ServiceType);
      }           
   }
}





