//  2011 IDesign Inc.
// Pytania? Komentarze? Odwied
// http://www.idesign.net

using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Web.Services.Protocols;

namespace CredentialsManagerClient
{
   partial class ChangePasswordDialog : Form
   {
      string m_Url;
      string m_Application;
      PasswordManagerProxy m_PasswordManager;

      public ChangePasswordDialog(string url,string application,string user)
      {
         InitializeComponent();

         m_Url = url;
         m_Application = application;
         m_UserNameTextBox.Text = user;

         m_PasswordManager = new PasswordManagerProxy(m_Url);
         m_PasswordQuestionTextBox.Text = m_PasswordManager.GetPasswordQuestion(application,user);

         m_PasswordAnswerTextBox.Enabled =  m_PasswordManager.RequiresQuestionAndAnswer(application);
      }
      void OnChange(object sender,EventArgs e)
      {
         if(m_PasswordAnswerTextBox.Text == String.Empty && m_PasswordAnswerTextBox.Enabled)
         {
            m_Validator.SetError(m_PasswordAnswerTextBox,"Odpowied na pytanie nie moe by pusta");
            return;
         }
         m_Validator.Clear();

         if(m_NewPasswordTextBox.Text == String.Empty)
         {
            m_Validator.SetError(m_NewPasswordTextBox,"Nowe haso nie moe by puste");
            return;
         }
         m_Validator.Clear();

         if(m_PasswordAnswerTextBox.Enabled)
         {
            try
            {
               m_PasswordManager.ChangePasswordWithAnswer(m_Application,m_UserNameTextBox.Text,m_PasswordAnswerTextBox.Text,m_NewPasswordTextBox.Text);
            }
            catch(SoapException exception)
            {
               if(exception.Message.Contains("Podana odpowied jest nieprawidowa"))
               {
                  MessageBox.Show("Podana odpowied jest nieprawidowa. Sprbuj ponownie.","Meneder danych uwierzytelniajcych",MessageBoxButtons.OK,MessageBoxIcon.Error);
                  return;
               }
               if(exception.Message.Contains("Konto uytkownika zostao zablokowane"))
               {
                  MessageBox.Show("Konto uytkownika zostao zablokowane","Meneder danych uwierzytelniajcych",MessageBoxButtons.OK,MessageBoxIcon.Error);
                  Close();
                  return;
               }
               throw;
            }
         }
         else
         {
            try
            {
               m_PasswordManager.ChangePassword(m_Application,m_UserNameTextBox.Text,m_NewPasswordTextBox.Text);
            }
            catch(SoapException exception)
            {
               if(exception.Message.Contains("Konto uytkownika zostao zablokowane"))
               {
                  MessageBox.Show("Konto uytkownika zostao zablokowane","Meneder danych uwierzytelniajcych",MessageBoxButtons.OK,MessageBoxIcon.Error);
                  Close();
                  return;
               }
               throw;
            }
         }
         Close();
      }

      void OnClosed(object sender,FormClosedEventArgs e)
      {
         m_PasswordManager.Close();
      }
   }
}