﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.Status;
using Microsoft.WindowsMobile.PocketOutlook;

namespace MonitorowanieTelefonu
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            Refresh();
            aktywujPowiadomienie();
        }

        static string JestBrak(bool wartoscLogiczna)
        {
            return wartoscLogiczna ? "Jest" : "Brak";
        }

        static string TakNie(bool wartoscLogiczna)
        {
            return wartoscLogiczna ? "Tak" : "Nie";
        }

        string[] pobierzInformacjeOStanieTelefonu()
        {
            List<string> lista = new List<string>();
            lista.Add("Stan telefonu (" + SystemState.Time.ToString() + "):");
            lista.Add("Telefon: " + JestBrak(SystemState.PhoneRadioPresent));
            lista.Add("Karta SIM: " + JestBrak(!SystemState.PhoneNoSim));
            lista.Add("Telefon włączony: " + TakNie(!SystemState.PhoneRadioOff));
            lista.Add("Połączony z siecią: " + TakNie(!SystemState.PhoneNoService));
            lista.Add("Nazwa operatora: " + SystemState.PhoneOperatorName);
            lista.Add("Poziom sygnału: " + SystemState.PhoneSignalStrength.ToString());
            lista.Add("Roaming aktywny: " + TakNie(SystemState.PhoneRoaming));
            lista.Add("");
            lista.Add("Ilość nieodebranych połączeń: " + SystemState.PhoneMissedCalls);
            
            lista.Add("");
            lista.Add("---------");
            lista.Add("");

            /*
            lista.Add("Próba połączenia wychodzącego: " + TakNie(SystemState.PhoneCallCalling));
            lista.Add("Próba połączenia przychodzącego: " + TakNie(SystemState.PhoneIncomingCall));
            if(SystemState.PhoneIncomingCall)
            {
                lista.Add("   Numer: " + SystemState.PhoneIncomingCallerNumber);
                lista.Add("   Nazwa: " + SystemState.PhoneIncomingCallerName);
            }            
            lista.Add("Trwa rozmowa: " + TakNie(SystemState.PhoneCallTalking));
            if(SystemState.PhoneCallTalking)
            {
                lista.Add("   Numer: " + SystemState.PhoneTalkingCallerNumber);
                lista.Add("   Nazwa: " + SystemState.PhoneTalkingCallerName);
                lista.Add("   Czas rozpoczęcia: " + SystemState.PhoneTalkingCallStartTime);
            }
            */

            return lista.ToArray();
        }

        public override void Refresh()
        {
            base.Refresh();

            try
            {
                listBox1.Items.Clear();
                string[] wlasnosci = pobierzInformacjeOStanieTelefonu();
                foreach (string wlasnosc in wlasnosci)
                    listBox1.Items.Add(wlasnosc);
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd przy odczycie stanu urządzenia!\n" + exc.Message);
            }
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            Close();
        }


        #region powiadomienie o nieodebranych polaczeniach przychodzacych
        SystemState monitorowaniePolaczenPrzychodzacych;

        void aktywujPowiadomienie()
        {
            monitorowaniePolaczenPrzychodzacych = new SystemState(SystemProperty.PhoneMissedCalls);
            monitorowaniePolaczenPrzychodzacych.Changed += new ChangeEventHandler(zmianaStanu);
        }

        string[] pobierzInformacjeOProbiePolaczenia(out string numerTelefonu)
        {
            List<string> lista = new List<string>();
            numerTelefonu = SystemState.PhoneLastIncomingCallerNumber;
            lista.Add("Numer: " + numerTelefonu);
            //Contact kontakt = SystemState.PhoneLastIncomingCallerContact;
            lista.Add("Nazwa: " + SystemState.PhoneLastIncomingCallerName);
            lista.Add("Data: " + DateTime.Now.ToString());
            lista.Add("Ilość nieodebranych połączeń: " + SystemState.PhoneMissedCalls);
            return lista.ToArray();
        }

        bool wysylajSMS = true;
        string trescSMS = "Jestem na wakacjach. Proszę ponowić próbę kontaktu po 4.01.2010";
        bool potwierdzenieOdebraniaSMS = false;

        void zmianaStanu(object sender, ChangeEventArgs args)
        {
            string numerTelefonu;
            string[] opis = pobierzInformacjeOProbiePolaczenia(out numerTelefonu);
            foreach (string linia in opis)
                listBox1.Items.Add(linia);
            
            if (wysylajSMS)
            {
                SmsMessage sms = new SmsMessage(numerTelefonu, trescSMS);
                sms.RequestDeliveryReport = potwierdzenieOdebraniaSMS;
                try
                {
                    sms.Send();
                    listBox1.Items.Add("SMS wysłany");
                }
                catch (Exception exc)
                {
                    listBox1.Items.Add("SMS nie wysłany (" + exc.Message + ")");
                }
            }

            listBox1.Items.Add("");
        }
        #endregion
    }
}