﻿#if DEBUG
#warning Pamiętaj o skompilowaniu ostatecznej wersji z optymalizacją
#endif

#if PocketPC
#warning Aplikacja projektowana dla urządzeń przenośnych
#endif

#if DEBUG
#warning Kompilacja "debug"
#else
#warning Kompilacja "release"
#endif

using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Para;
using ParaInt = Para.Para<int>;
using ParaDouble = Para.Para<double>;
using ParaString = Para.Para<string>;

using ParaIntInt = Para.Para<int, int>;
using ParaDoubleDouble = Para.Para<double, double>;
using ParaStringString = Para.Para<string, string>;
using ParaIntDouble = Para.Para<int, double>;


namespace JezykCS
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            #if DEBUG
            //MessageBox.Show("Kompilacja \"debug\"");
            #endif

            PrzestarzałaMetoda();
        }

        public enum DniTygodnia :
                byte { niedziela = 1, poniedzialek, wtorek, sroda, czwartek, piatek, sobota };

        delegate int Uchwyt(byte arg);
        private int Kwadrat(byte arg)
        {
            return arg * arg;
        }
        event Uchwyt ZdarzenieKwadrat;

        delegate int DInc(int n);
        delegate bool DIsEqual(double x, double y);
        delegate void DShow(int n);

        private void button1_Click(object sender, EventArgs e)
        {
            int i = 1;
            long l = 1L;
            //string s = "Helion";
            float f = 1.0f;
            double d = 1.0;

            var vi = 5;
            var vl = 5L;
            var vs = "Helion";
            var vf = 1.0f;
            var vd = 1.0;

            double x = 1; //to jest OK
            //int xi = 1.0; //tu pojawi się błąd

            //Operator is
            Object o = new Button();
            if (o is Button) MessageBox.Show("Obiekt jest przyciskiem");
            MessageBox.Show(o.GetType().ToString());

            //Operator as
            //Button b = null;
            //if (o is Button) b = (Button)o;

            Button b = o as Button;

            //Łańcuchy
            string s = "Wydawnictwo Helion";
            int dlugosc = s.Length;

            string helion = "Wydawnictwo \" \u0048 \u0065 \u006c \u0069 \u006f \u006e \"";
            string nazwapliku = "\\Windows\\BubbleBreaker.exe";
            string nazwapliku1 = @"\Windows\BubbleBreaker";

            //Typ wyliczeniowy            
            byte nrDniaTygodnia = (byte)DniTygodnia.poniedzialek;

            //Delegacje i zdarzenia
            Uchwyt UchwytMetodyKwadrat = new Uchwyt(Kwadrat);

            int i1 = Kwadrat(2);
            int j = UchwytMetodyKwadrat(2);
            ZdarzenieKwadrat += new Uchwyt(Kwadrat);
            int k = ZdarzenieKwadrat(2);
            MessageBox.Show("i=" + i1 + ", j=" + j + ", k=" + k);

            //Wyrażenia Lambda
            DInc Inc = (int n) => n + 1;
            MessageBox.Show("Inc(1)=" + Inc(1));

            DIsEqual IsEqual = (x1, y1) => x1 == y1;
            int a1 = 10;
            int b1 = 20;
            MessageBox.Show("Czy równe a=" + a1 + " i b=" + b1 + "? " + (IsEqual(a1, b1) ? "Tak" : "Nie"));
            MessageBox.Show("Czy równe a=" + a1 + " i a=" + a1 + "? " + (IsEqual(a1, a1) ? "Tak" : "Nie"));

            DShow Show = n => { MessageBox.Show(n.ToString()); };
            Show(10);

            string[] slowa = { "czereśnia", "jabłko", "borówka", "wiśnia", "jagoda" };
            int dlugoscNajkrotszego = slowa.Min(slowo => slowo.Length);
            //int dlugoscNajkrotszego = slowa.Min(delegate(string slowo) { return slowo.Length; });
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //if..else
            Random r = new Random();
            int n = r.Next(8);
            MessageBox.Show("" + n);

            //Składnia podstawowa if
            if (n < 6) MessageBox.Show("Wylosowana liczba jest mniejsza od 6.");

            //Składnia rozszerzona if..else
            if (n <= 4) MessageBox.Show("Wylosowana liczba jest mniejsza lub równa 4.");
            else MessageBox.Show("Wylosowana liczba jest większa od 4.");
        }

        private void button3_Click(object sender, EventArgs e)
        {
            Random r = new Random();
            int n = r.Next(8);
            string opis;
            switch (n)
            {
                case 1: opis = "niedziela"; break;
                case 2: opis = "poniedziałek"; break;
                case 3: opis = "wtorek"; break;
                case 4: opis = "środa"; break;
                case 5: opis = "czwartek"; break;
                case 6: opis = "piątek"; break;
                case 7: opis = "sobota"; break;
                default: opis = "błąd!"; break;
            }
            MessageBox.Show("Dzień tygodnia: " + n + ", " + opis);
        }

        long silnia(byte arg)
        {
            if (arg == 0) return 0;
            long wartosc = 1;
            for (byte i = 1; i <= arg; i++)
                wartosc *= i;
            return wartosc;
        }

        long najwiekszyDzielnik(long arg)
        {
            long dzielnik = arg - 1;
            while (arg % dzielnik != 0)
                dzielnik--;
            return dzielnik;
        }

        private void button4_Click(object sender, EventArgs e)
        {
            //silnia
            int liczba = 5;
            MessageBox.Show(liczba.ToString() + "!=" + silnia(5).ToString());

            //najwiekszy dzielnik
            liczba = new Random().Next(100);
            MessageBox.Show("Najwiekszy dzielnik " + liczba.ToString() + " to " + najwiekszyDzielnik(liczba));
        }

        private void button5_Click(object sender, EventArgs e)
        {
            Random r = new Random();
            int n = r.Next(8);
            //Zadanie komputera to odgadnąć 
            //liczbę z zakresu od 0 do 7
            int z; int licznik = 0;
            do
            {
                licznik++;
                z = r.Next(8);
            }
            while (n != z);
            MessageBox.Show("Komputer zgadł liczbę " + z + " po " + licznik + " próbach!");
        }

        private void zakresDouble(ref double min, ref double max)
        {
            min = double.MinValue;
            max = double.MaxValue;
            MessageBox.Show("Liczby double mogą należeć do przedziału (" + min + "," + max + ")");
        }

        private void button6_Click(object sender, EventArgs e)
        {
            double min = 0, max = 0;
            zakresDouble(ref min, ref max);
            MessageBox.Show("Liczby double mogą należeć do przedziału (" + min + "," + max + ")");
        }

        private void button7_Click(object sender, EventArgs e)
        {
            //int x1 = 0; int y1 = 1 / x1;

            try
            {
                //throw new Exception("Komunikat opisujący błąd");

                int x = 0;
                int y = 1 / x;
                MessageBox.Show("Kod wykonywany jeżeli nie nastąpił wyjątek");
            }
            catch (DivideByZeroException exc)
            {
                MessageBox.Show("Dzielenie przez zero");
                return;
            }
            catch (Exception exc)
            {
                MessageBox.Show("Inne wyjątki\n" + exc.Message);
                return;
            }
            finally
            {
                MessageBox.Show("Kod wykonywany w każdym przypadku");
            }
            MessageBox.Show("Kod wykonywany jeżeli nie nastąpił wyjątek (ze względ na return w catch)");
        }

        [Obsolete("Metoda przestarzała. Lepiej użyj metody NowaMetoda", false)]
        void PrzestarzałaMetoda() 
        {
        }

        #region Kolekcje
        private void button8_Click(object sender, EventArgs e)
        {
            //jednowymiarowa tablica przyciskow
            Button[] b = new Button[5];
            for (int i = 0; i < b.Length; i++)
            {
                b[i] = new Button();
                b[i].Text = "" + i;
                //b[i].Parent = this;
                b[i].Parent = tabPage2;
                b[i].Top = i * 30;                                
            }

            //tablica dwuwymiarowa
            int[,] i2 = new int[2, 3];
            for (int i = 0; i < 2; i++)
                for (int j = 0; j < 3; j++)
                    i2[i, j] = 3 * i + j;

            //foreach
            foreach (Button bi in b)
            {
                bi.Text = "" + 0;
                MessageBox.Show(bi.Text);
            }

            foreach (int i in i2) MessageBox.Show("" + i);
        }

        private void button9_Click(object sender, EventArgs e)
        {
            int[] losy = new int[30];
            Random r = new Random();
            for (int indeks = 0; indeks < losy.Length; indeks++)
                losy[indeks] = r.Next(100);

            string s = "Przed sortowaniem:\n";
            foreach (int los in losy) s += los.ToString() + "\t";
            MessageBox.Show(s);

            Array.Sort(losy);

            s = "Po sortowaniu:\n";
            foreach (int los in losy) s += los.ToString() + "\t";
            MessageBox.Show(s);
        }

        private void button10_Click(object sender, EventArgs e)
        {
            int rozmiar = 30;
            Random r = new Random();
            List<int> a = new List<int>(new int[rozmiar]);
            for (int i = 0; i < rozmiar; i++) a[i] = r.Next(100);
            a.AddRange(new int[10]);
            int[] i5 = { -1, -1, -1, -1, -1 };
            a.InsertRange(rozmiar / 2, i5);
            a.Insert(0, 1);

            /*
            //tu kryją się błędy
            for (int i = 0; i < rozmiar; i++)
            {
                if (a[i] > 20)
                    a.RemoveAt(i);
            }
            */

            //poprawione
            for (int i = 0; i < a.Count; i++)
            {
                if (a[i] > 20)
                {
                    a.RemoveAt(i);
                    i--;
                }
            }

            a.Sort();

            string s = "Elementy listy:\n";
            foreach (object ai in a) s += ai.ToString() + "\t";
            MessageBox.Show(s);
        }

        private void button11_Click(object sender, EventArgs e)
        {
            SortedList<string, string> artysci = new SortedList<string, string>();
            artysci.Add("Sting", "Gordon Matthew Sumner");
            artysci.Add("Bolesław Prus", "Aleksander Głowacki");
            artysci.Add("Pola Negri", "Barbara Apolonia Chałupiec");
            artysci.Add("John Wayne", "Marion Michael Morrison");
            artysci.Add("Chico", "Leonard Marx");
            artysci.Add("Harpo", "Arthur Marx");
            artysci.Add("Groucho", "Julius Marx");
            artysci.Add("Bono", "Paul Hewson");
            artysci.Add("Ronaldo", "Luiz Nazario de Lima");
            artysci.Add("Madonna", "Madonna Louise Veronica Ciccone");
            artysci.Add("Gabriela Zapolska", "Maria G. Śnieżko-Błocka");

            string komunikat = "Zawartość listy:\n\n";
            foreach (KeyValuePair<string, string> artysta in artysci)
                komunikat += artysta.Key + " - " + artysta.Value + "\n";
            MessageBox.Show(komunikat);
        }

        private int Suma(params int[] lista)
        {
            MessageBox.Show("Liczba argumentów: " + lista.Length);
            int suma = 0;
            foreach (int liczba in lista) suma += liczba;
            return suma;
        }

        private void button12_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Suma: " + Suma(new int[] { 1, 2, 3 }));
            MessageBox.Show("Suma: " + Suma(1, 2, 3));
        }
        #endregion

        #region Klasy i obiekty - Ulamek
        private void button13_Click(object sender, EventArgs e)
        {
            //poczatek i konwersja na lancuch
            Ulamek u2 = new Ulamek(2, 1);
            Ulamek u0 = Ulamek.Zero;
            Ulamek uP = Ulamek.Polowa;
            MessageBox.Show(uP.ToString());

            //upraszczanie ulamka
            Ulamek u = new Ulamek(4, -2);
            u.Uprosc();
            MessageBox.Show(u.ToString());

            //operatory arytmetyczne
            Ulamek a = Ulamek.Polowa;
            Ulamek b = Ulamek.Cwierc;

            MessageBox.Show((a + b).ToString());
            MessageBox.Show((a - b).ToString());
            MessageBox.Show((a * b).ToString());
            MessageBox.Show((a / b).ToString());

            //operatory konwersji
            double r = (double)Ulamek.Polowa;
            MessageBox.Show(r.ToString());
            Ulamek c = 1;
            MessageBox.Show(c.ToString());
        }

        private void button14_Click(object sender, EventArgs e)
        {
            //tablica ulamkow
            Ulamek[] tablica = new Ulamek[10];
            for (int i = 0; i < tablica.Length; i++) tablica[i] = new Ulamek(1, i + 1);

            string s = "";
            foreach (Ulamek u in tablica) s += u.ToString() + "=" + u.ToDouble().ToString() + "\n";
            MessageBox.Show(s);

            try
            {
                Array.Sort(tablica);
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }

            s = "Po sortowaniu:\n";
            foreach (Ulamek u in tablica) s += u.ToString() + "=" + u.ToDouble().ToString() + "\n";
            MessageBox.Show(s);
        }
        #endregion

        #region Klasy i obiekty - Para
        private void button15_Click(object sender, EventArgs e)
        {
            Random r = new Random();

            //int
            Para<int>[] pi = new Para<int>[10];
            for (int i = 0; i < pi.Length; i++)
                pi[i] = new Para<int>(r.Next(10), r.Next(10));
            string si = "";
            foreach (Para<int> para in pi) si += para.ToString() + "\n";
            MessageBox.Show("Para<int>\n" + si);
            Array.Sort(pi);
            si = "";
            foreach (Para<int> para in pi) si += para.ToString() + "\n";
            MessageBox.Show("Para<int> po sortowaniu\n" + si);

            //double
            Para<double>[] pd = new Para<double>[10];
            for (int i = 0; i < pi.Length; i++)
                pd[i] = new Para<double>(r.NextDouble(), r.NextDouble());
            string sd = "";
            foreach (Para<double> para in pd) sd += para.ToString() + "\n";
            MessageBox.Show("Para<double>\n" + sd);
            Array.Sort(pd);
            sd = "";
            foreach (Para<double> para in pd) sd += para.ToString() + "\n";
            MessageBox.Show("Para<double> po sortowaniu\n" + sd);

            //string
            Para<string>[] ps = new Para<string>[12];
            ps[0] = new Para<string>("Bester", "Alfred");
            ps[1] = new Para<string>("Dick", "Philip");
            ps[2] = new Para<string>("Tolkien", "John");
            ps[3] = new Para<string>("Lem", "Stanisław");
            ps[4] = new Para<string>("Anderson", "Poul");
            ps[5] = new Para<string>("Pohl", "Frederik");
            ps[6] = new Para<string>("Le Guin", "Ursula");
            ps[7] = new Para<string>("Card", "Orson");
            ps[8] = new Para<string>("Gibson", "William");
            ps[9] = new Para<string>("Asimov", "Isaac");
            ps[10] = new Para<string>("Niven", "Larry");
            ps[11] = new Para<string>("Herbert", "Frank");
            string ss = "";
            foreach (Para<string> para in ps) ss += para.ToString() + "\n";
            MessageBox.Show("Para<string>\n" + ss);
            Array.Sort(ps);
            ss = "";
            foreach (Para<string> para in ps) ss += para.ToString() + "\n";
            MessageBox.Show("Para<string> po sortowaniu\n" + ss);
        }

        private void button16_Click(object sender, EventArgs e)
        {
            Random r = new Random();

            //int-double
            ParaIntDouble[] p = new ParaIntDouble[10];
            for (int i = 0; i < p.Length; i++)
                p[i] = new ParaIntDouble(r.Next(10), r.NextDouble());
            string s = "";
            foreach (ParaIntDouble para in p) s += para.ToString() + "\n";
            MessageBox.Show("Para<int,double>\n" + s);
            Array.Sort(p);
            s = "";
            foreach (ParaIntDouble para in p) s += para.ToString() + "\n";
            MessageBox.Show("Para<int,double> po sortowaniu\n" + s);
        }

        private void button17_Click(object sender, EventArgs e)
        {
            //1
            //Ulamek u = new Ulamek();
            //u.Licznik = 1;
            //u.Mianownik = 2;

            //2
            //Ulamek u = new Ulamek(1, 2);

            //3
            Ulamek u = new Ulamek { Licznik = 1, Mianownik = 2 };

            MessageBox.Show(u.ToString());

            var it = new[] { 5, 4, 3, 2, 1, 0 };
            var lt = new[] { 5L, 4L, 3L, 2L, 1L, 0L };
            var st = new[] { "Helion", "Onepress", "Sensus", "Septem", "Editio" };
            var ft = new[] { 1.0f, 0.75f, 0.5f, 0.25f, 0.0f };
            var dt = new[] { 1.0, 0.75, 0.5, 0.25, 0.0 };

            List<string> lista = new List<string> { "Helion", "Onepress", "Sensus", "Septem", "Editio" };
        }
        #endregion

        private void button18_Click(object sender, EventArgs e)
        {
            var anonim = new { i = 1, l = 1L, s = "Helion", f = 1.0f, d = 1.0 };
            MessageBox.Show(anonim.GetType().FullName);
        }        

        #region LINQ

        class Osoba
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu;
            public int Wiek;
        }

        //źródło danych
        List<Osoba> listaOsob = new List<Osoba> 
    { 
        new Osoba { Id = 1, Imię = "Jacek", Nazwisko = "Matulewski", 
                    NumerTelefonu = 7272024, Wiek = 37 }, 
        new Osoba { Id = 2, Imię = "Katarzyna", Nazwisko = "Matulewska", 
                    NumerTelefonu = 7272020, Wiek = 38 },
        new Osoba { Id = 3, Imię = "Karolina", Nazwisko = "Matulewska", 
                    NumerTelefonu = 7272021, Wiek = 9 }, 
        new Osoba { Id = 4, Imię = "Bartosz", Nazwisko = "Matulewski", 
                    NumerTelefonu = 7272022, Wiek = 4 } 
    };


        private void button19_Click(object sender, EventArgs e)
        {            
            var listaOsobPelnoletnich1 = from osoba in listaOsob where osoba.Wiek >= 18 orderby osoba.Wiek select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };

            //Pobieranie danych (filtrowanie i sortowanie)
            var listaOsobPelnoletnich = from osoba in listaOsob where osoba.Wiek >= 18 orderby osoba.Wiek select osoba;
            List<Osoba> podlista = listaOsobPelnoletnich.ToList<Osoba>();

            //Prezentacja pobranych danych
            string s = "Lista osób pełnoletnich:\n";
            foreach (var osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);

            //Kalkulacje
            MessageBox.Show("Wiek najstarszej osoby: " + listaOsobPelnoletnich.Max(osoba => osoba.Wiek));
            MessageBox.Show("Średni wiek osób pełnoletnich: " + listaOsobPelnoletnich.Average(osoba => osoba.Wiek));
            MessageBox.Show("Suma lat osób pełnoletnich: " + listaOsobPelnoletnich.Sum(osoba => osoba.Wiek));

            //Wybór elementu
            var najstarszaOsoba = listaOsobPelnoletnich.Single(osoba1 => (osoba1.Wiek == listaOsobPelnoletnich.Max(osoba => osoba.Wiek)));
            MessageBox.Show("Najstarsza osoba: " + najstarszaOsoba.Imię + " " + najstarszaOsoba.Nazwisko + " (" + najstarszaOsoba.Wiek + ")");

            //Testowanie danych
            bool czySpełniaWarunek = listaOsobPelnoletnich.All(osoba => (osoba.Wiek > 18));
            bool czyZawieraPelnoletnią = listaOsob.Any(osoba => (osoba.Wiek > 18));

            //Prezentacja w grupach
            var grupyOsobOTymSamymNazwisku = from osoba in listaOsob
                                             group osoba by osoba.Nazwisko into grupa
                                             select grupa;
            s = "Lista osób pogrupowanych nazwiskami:\n\n";
            foreach (var grupa in grupyOsobOTymSamymNazwisku)
            {
                s += "Grupa osób o nazwisku " + grupa.Key + "\n";
                foreach (Osoba osoba in grupa)
                    s += osoba.Imię + " " + osoba.Nazwisko + "\n";
                s += "\n";
            }
            MessageBox.Show(s);

            //Łączenie zbiorów danych            
            var listaKobiet = from osoba in listaOsob
                              where osoba.Imię.EndsWith("a")
                              select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
            //var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich1.Concat(listaKobiet);
            //var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich1.Concat(listaKobiet).Distinct();
            var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich1.Union(listaKobiet);
            var listaKobietPelnoletnich = listaOsobPelnoletnich1.Intersect(listaKobiet);
            var listaPelnoletnichNiekobiet = listaOsobPelnoletnich1.Except(listaKobiet);

            s = "Suma list pełnoletnich i kobiet:\n";
            foreach (var osoba in listaPelnoletnich_I_Kobiet) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);
            s = "Lista pełnoletnich kobiet:\n";
            foreach (var osoba in listaKobietPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s); 

            //Operator join
            var listaTelefonów = from osoba in listaOsob select new { osoba.Id, osoba.NumerTelefonu };
            var listaPersonaliów = from osoba in listaOsob select new { osoba.Id, osoba.Imię, osoba.Nazwisko };

            var listaPersonaliówZTelefonami = from telefon in listaTelefonów
                                              join personalia in listaPersonaliów
                                              on telefon.Id equals personalia.Id
                                              select new
                                              {
                                                  telefon.Id,
                                                  personalia.Imię,
                                                  personalia.Nazwisko,
                                                  telefon.NumerTelefonu
                                              };

            s = "Lista personaliów połączona z listą telefonów:\n";
            foreach (var osoba in listaPersonaliówZTelefonami) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.NumerTelefonu + ")\n";
            MessageBox.Show(s); 
        }
        #endregion

        private void button20_Click(object sender, EventArgs e)
        {
            var listaOsobPelnoletnich = from osoba in listaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Wiek
                                        select osoba;

            string s = "Lista osób (przed zmianą):\n";
            foreach (var osoba in listaOsob) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s); 

            Osoba pierwszyNaLiscie = listaOsobPelnoletnich.First<Osoba>();
            pierwszyNaLiscie.Imię = "Jan";
            pierwszyNaLiscie.Nazwisko = "Kowalski";
            pierwszyNaLiscie.Wiek = 24;

            s = "Lista osób (po zmianie):\n";
            foreach (var osoba in listaOsob) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s); 
        }

        private void button21_Click(object sender, EventArgs e)
        {
            Nullable<int> ni = null;
            //int? ni = null;
            //ni = 1;
            int i1;
            if (ni.HasValue)
            {
                i1 = ni.Value;
                //i1 = (int)ni;                
            }
            else
            {
                i1 = default(int);
            }
            int i2 = ni.GetValueOrDefault();
            MessageBox.Show("i1=" + i1 + ", i2=" + i2);
        }

        private void button22_Click(object sender, EventArgs e)
        {
            //kontrola przekroczenia zakresu
            int i = unchecked(int.MaxValue + 1); //tu powinien wystapic wyjatek
            MessageBox.Show("i=" + i);
        }

        private void button23_Click(object sender, EventArgs e)
        {
            //string
            string s = "abc---";
            s += "xyz";
            s = s.Replace("---", " ijk ");
            MessageBox.Show(s);

            //StringBuilder
            StringBuilder sb = new StringBuilder("abc---");
            sb.Append("xyz");
            sb.Replace("---", " ijk ");
            MessageBox.Show(sb.ToString());
        }

        private void button24_Click(object sender, EventArgs e)
        {
            //nieskonczonosc
            double d = -1;
            d /= 0;
            MessageBox.Show(d.ToString());
        }

        private void button25_Click(object sender, EventArgs e)
        {
            //wartość domyślna typu
            int i = default(int);
            MessageBox.Show(i.ToString());
        }

        private void button26_Click(object sender, EventArgs e)
        {
            //boxing
            int i = 1;
            object o = i;
            MessageBox.Show(o.GetType().ToString()); //zwraca System.Int32

            //unboxing
            int j = (int)o;
            MessageBox.Show(j.ToString());
        }

        private void button27_Click(object sender, EventArgs e)
        {
            //uruchomienie tego kodu skończy się błędem
            Button[] przyciski = new Button[100];
            Random r = new Random();
            for (int indeks = 0; indeks < przyciski.Length; indeks++)
            {
                przyciski[indeks] = new Button();
                przyciski[indeks].Text = "" + r.Next(100);
            }
            Array.Sort(przyciski);
        }
    }
}