import java.util.Scanner;
/** Klasa <code>MyDoubleArray</code> zawiera statyczne metody uatwiajce
  * wprowadzanie danych do jednowymiarowej tablicy liczb 
  * zmiennoprzecinkowych typu <code>double</code>, wywietlanie 
  * zawartoci tablicy na konsoli oraz konwertowania tablicy liczb 
  * cakowitych typu <code>int</code> lub zmiennoprzecinkowych typu 
  * <code>float</code> na tablic liczb zmiennoprzecinkowych typu 
  * <code>double</code>.
  * @author Wiesaw Rychlicki
  * @version 1.0 (2012-02-06)
  */
public class MyDoubleArray {
/** Umoliwia wprowadzanie danych liczbowych (typu <code>double</code>)
  * z konsoli do tablicy. Dane wprowadzane s przy uyciu metod z klasy
  * <code>java.util.Scanner</code>. Podczas wprowadzania danych 
  * wywietlana jest informacja postaci: <code>Liczba 2 z 5, x = </code>.
  * @param tab jednowymiarowa tablica liczb typu <code>double</code>.
  */
    public static void input(double[] tab) {
        int n = tab.length;
        Scanner input = new Scanner(System.in);
        for(int i = 0; i < n; ++i) { 
            System.out.printf("Liczba %d z %d, x = ", i+1, n);
            tab[i] = input.nextDouble();
        }
    }
/** Umoliwia wywietlanie liczb zawartych w tablicy na konsoli.
  * Kolejne liczby oddzielane s odstpem.
  * @param tab jednowymiarowa tablica liczb typu <code>double</code>.
  */
    public static void print(double[] tab) {
        int n = tab.length;
        for(int i = 0; i < n; ++i)
            System.out.print(tab[i]+" ");
    }
/** Umoliwia wywietlanie liczb zawartych w tablicy na konsoli.
  * Kolejne liczby oddzielane s odstpem. Po wywietleniu ostaniej
  * liczby, do konsoli przesyany jest znak koca linii.
  * @param tab jednowymiarowa tablica liczb typu <code>double</code>.
  */
    public static void println(double[] tab) {
        int n = tab.length;
        for(int i = 0; i < n; ++i)
            System.out.print(tab[i]+" ");
        System.out.println();    
    }
/** Umoliwia wywietlanie sformatowych liczb (zapisanych w tablicy) na 
  * konsoli. Sposb formatowania okrelony jest przy pomocy parametru 
  * <code>spec</code>, w sposb okrelony w klasie 
  * <a href="http://docs.oracle.com/javase/1.5.0/docs/api/java/util/Formatter.html">
  * Formatter</a>, np.: <code>"%.2f "</code> - wywietla liczb 
  * zmiennoprzecinkow z dwoma miejscami po przecinku.
  * @param spec acuch znakw okrelajcy format liczby.
  * @param tab jednowymiarowa tablica liczb typu <code>double</code>.
  */
    public static void printf(String spec, double[] tab) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        System.out.printf(spec, tab[i]);
    }    
/** Zwraca jednowymiarow tablic liczb typu <code>int</code>, 
  * o wartociach odpowiadajcych wartociom (zaokrglonym w d) 
  * z tablicy liczb typu <code>double</code> przekazanej jako parametr.
  * @param tab jednowymiarowa tablica liczb typu <code>double</code>.
  */
    public static int[] toIntArray(double[] tab) {
        int n = tab.length;
        int[] tmp = new int[n];
        for(int i = 0; i < n; ++i)  
            tmp[i] = (int)tab[i];
        return tmp;
    }
/** Zwraca jednowymiarow tablic liczb typu <code>double</code>, 
  * o wartociach rwnych wartociom elementw tablicy liczb cakowitych 
  * typu <code>int</code> przekazanej jako parametr.
  * @param tab jednowymiarowa tablica liczb cakowitych typu 
  * <code>int</code>.
  */
    public static double[] toDoubleArray(int[] tab) {
        int n = tab.length;
        double[] tmp = new double[n];
        for(int i = 0; i < n; ++i)  
            tmp[i] = (double)tab[i];
        return tmp;
    }
/** Zwraca jednowymiarow tablic liczb typu <code>double</code>, 
  * o wartociach rwnych wartociom elementw tablicy liczb 
  * zmiennoprzecinkowych typu <code>float</code> przekazanej jako 
  * parametr.
  * @param tab jednowymiarowa tablica liczb zmiennoprzecinkowych typu 
  * <code>float</code>.
  */
    public static double[] toDoubleArray(float[] tab) {
        int n = tab.length;
        double[] tmp = new double[n];
        for(int i = 0; i < n; ++i)  
            tmp[i] = (double)tab[i];
        return tmp;
    }    
}
