public class Z28_23a {
	public static double[][] product (double[][] x, double[][] y) {
		if (x[0].length != y.length)
		    throw new ArithmeticException("Niezgodne wymiary macierzy");
		double[][] tmp = new double[x.length][y[0].length];
		for(int i = 0; i < x.length; ++i) 
            for(int j = 0; j < y[0].length; ++j)
                for(int k = 0; k < y.length; ++k)
                    tmp[i][j] += x[i][k]*y[k][j];
        return tmp;
	}
	private static double[][] inverse(double[][] x) {
		if (x.length != x[0].length)
		    throw new ArithmeticException("To nie jest macierz kwadratowa");
		int n = x.length;
		    
	    double[][] tmp = new double[n][n];
	    for(int i = 0; i < n; ++i)
	        for(int j = 0; j < n; ++j)
	            tmp[i][j] = x[i][j];
	            
	    double[][] I = new double[n][n];
	    for(int i = 0; i < n; ++i)
	        I[i][i] = 1.0;
	                  
	    for(int i = 0; i < n; ++i) {    
	        for(int j = 0; j < n; ++j)  {
		        if (tmp[i][i] != 0.0) {
			        if (j != i) {
		                double p = tmp[j][i]/tmp[i][i];
		                for(int k = 0; k < n; ++k) {
	                        tmp[j][k] -= tmp[i][k]*p;
	                        I[j][k] -= I[i][k]*p;
                        }
                    }
			        
		        } else {
                    for(int k = i+1; k < n; ++k) {
			            if (tmp[k][i] != 0.0) {
				            for(int m = 0; m < n; ++m) {
					            double p = tmp[i][m];
					            tmp[i][m] = tmp[k][m];
					            tmp[k][m] = -p;
					            p = I[i][m];
					            I[i][m] = I[k][m];
					            I[k][m] = -p;
				            }
				            break;
			            }			                
		            }
		            throw new ArithmeticException("Macierz odwrotna nie istnieje");
                }
                
            }
            double q = tmp[i][i];
            for(int k = 0; k < n; ++k) {
                    I[i][k] /= q;
                    tmp[i][k] /= q;
            }
        }   
	    return I;
    }
    	
    public static void main(String[] args) {
	    double[][] a = new double[4][4];
	    TDouble.setRandom(a, 10.0); 
	    System.out.println("Macierz A");
	    TDouble.printf("%8.2f", a);
	    double[][] b = inverse(a);
	    System.out.println("Macierz odwrotna B");
	    TDouble.printf("%8.2f", b);
	    System.out.println("Sprawdzenie AB");
	    TDouble.printf("%8.2f", product(a, b)); 
	    System.out.println("Sprawdzenie BA");
	    TDouble.printf("%8.2f", product(b, a)); 
	    double[][] c = {{1, 1, 1},{1, 1, 1}, {2, 2, 2}};
	    System.out.println("Macierz C");
	    TDouble.printf("%8.2f", c);
	    System.out.println("Macierz odwrotna D");
	    double[][] d = inverse(c);
	    TDouble.printf("%8.2f", d);;
    }
}