/** Klasa <code>Fraction</code> suy do wykonywania podstawowych dziaa na uamkach
  * zwykych (ang. <i>fraction</i> - uamek).
  * @author Wiesaw Rychlicki
  * @version 1.0 (2012-02-07)
  */
public class Fraction {
/** Licznik uamka (<i>numerator</i> - licznik). 
  */
    private int num;
    
/** Mianownik uamka (<i>denominator</i> - mianownik).
  */
    private int den;    

/** Tworzy nowy obiekt <code>Fraction</code> - uamek postaci <code>m/n</code> na podstawie
  * wartoci cakowitych parametrw <code>m</code> i <code>n</code>.
  * @param m liczba cakowita (licznik uamka),
  * @param n liczba cakowita (mianownik uamka).
  * @throws IllegalArgumentException gdy podamy mianownik n = 0.
  */
    Fraction (int m, int n) {
	    this.num = m;
	    if (n != 0)
	        this.den = n;
	    else
	        throw new IllegalArgumentException("Parametr n = 0!");
	    this.correction(); 
    }
    
/** Tworzy nowy obiekt <code>Fraction</code> - uamek postaci 
  * <code>m/1</code> o wartoci odpowiadajcej liczbie cakowitej 
  * <code>m</code>. 
  * @param m liczba cakowita (licznik uamka).
  */
    Fraction (int m) {
        this.num = m;
        this.den = 1;
    }
        
/** Tworzy nowy obiekt <code>Fraction</code> - uamek postaci 
  * <code>0/1</code> o wartoci odpowiadajcej liczbie cakowitej 
  * <code>0</code>. 
  */
    Fraction () {
        this.num = 0;
        this.den = 1;       
    }

/** Konstruktor kopiujcy - tworzy nowy obiekt <code>Fraction</code> 
  * o wartoci rwnej wartoci obiektu <code>x</code> klasy 
  * <code>Fraction</code>, podanego jako parametr.
  * @param x obiekt klasy <code>Fraction</code>.
  */
    Fraction (Fraction x) {
        this.num = x.num;
        this.den = x.den;
    }
    
/** Zwraca acuch znakw reprezentujcy ten obiekt 
  * <code>Fraction</code>. Przykad zwracaniego acucha 
  * <code>"3/4"</code>, <code>"-5/25"</code> itp.
  */
    @Override public String toString() {
        return num+"/"+den;
    }
     
/** Koryguje warto pl obiektu <code>Fraction</code> w taki sposb, aby 
  * mianownik by zawsze liczb dodatni. 
  */
    private void correction() {
        if (den < 0) {
           den = -den;
           num = -num;
       }
    }
    
/** Zwraca najwikszy wsplny dzielnik pary liczb cakowitych dodatnich 
  * <code>m</code> i <code>n</code>, podanych jako parametry wywoania 
  * metody. 
  * </br><b>Uwaga:</b> <i>Podanie ujemnych wartoci tych parametrw nie 
  * spowoduje bdu, znaki liczb zostan zignorowane - liczby zostan 
  * zastpione ich bezwzgldnymi wartociami</i>.
  * @param m liczba cakowita dodatnia,
  * @param n liczba cakowita dodatnia.
  */
    private int nwd(int m, int n) {
	    if (m == 0)
	        return n;
        if (m < 0) m = -m;
        if (n < 0) n = -n;
        while (m != n) 
            if (m > n) 
                m -= n; 
            else 
                n -= m;
        return m;
    }
    
/** Skraca uamek reprezentowany przez obiekt przez najwikszy wsplny 
  * dzielnik licznika i mianownika. 
  */
    public Fraction reduce() {
        int d = nwd(num, den);
        if (d != 1) {
            this.den /= d;
            this.num /= d;
        }
        return this;
    } 
/** Skraca uamek reprezentowany przez obiekt przez podany dzielnik 
  * <code>d</code>, o ile jest to moliwe. 
  * @param d liczba cakowita dodatnia typu <code>int</code>.
  * @throws IllegalArgumentException gdy podamy dzielnik 
  * <code>d &le; 0</code>.
  */
    public Fraction reduce(int d) {
        if (d <= 0)
            throw new IllegalArgumentException("Parametr d <= 0!");
        if (this.num%d == 0 && this.den%d ==0) {
            this.den /= d;
            this.num /= d;
        }
        return this;
    }
    
/** Rozszerza uamek reprezentowany przez obiekt przez podan liczb 
  * cakowit <code>n &ne; 0</code>. 
  * @param n liczba cakowita typu <code>int</code> rna od 0.
  * @throws IllegalArgumentException gdy podamy <code>n = 0</code>. 
  */
    public Fraction equivalent(int n) {
        if (n == 0)
            throw new IllegalArgumentException("Parametr n = 0!");
        this.den *= n;
        this.num *= n;
        this.correction(); // mianownik powinien pozosta dodatni
        return this;
    }
        
/** Zwraca nowy obiekt <code>Fraction</code> - iloczyn uamka 
  * reprezentowanego przez obiekt wywoujcy metod i uamka 
  * reprezentowanego przez obiekt przekazany jako parametr.
  * @param x uamek, obiekt klasy <code>Fraction</code>.
  */
    public Fraction mult(Fraction x) {
        return new Fraction(this.num*x.num, this.den*x.den).reduce();
    }

/** Zwraca nowy obiekt <code>Fraction</code> - iloczyn uamka 
  * reprezentowanego przez obiekt wywoujcy metod i liczby cakowitej 
  * typu <code>int</code> przekazanej jako parametr.
  * @param m liczba cakowita typu <code>int</code>.
  */
    public Fraction mult(int m) {
        return new Fraction(this.num*m, this.den).reduce();
    }
    
/** Zwraca obiekt klasy <code>Fraction</code> bdcy iloczynem dwch 
  * obiektw <code>Fraction</code>.
  * @param x obiekt klasy <code>Fraction</code>,
  * @param y obiekt klasy <code>Fraction</code>.
  */
    public static Fraction prod(Fraction x, Fraction y) {
        return x.mult(y);
    }

/** Zwraca obiekt klasy <code>Fraction</code> bdcy iloczynem obiektu 
  * <code>Fraction</code> i liczby cakowitej typu <code>int</code>.
  * @param x obiekt klasy <code>Fraction</code>,
  * @param m liczba cakowita typu <code>int</code>.
  */
    public static Fraction prod(Fraction x, int m) {
        return x.mult(m);
    }
/** Zwraca obiekt klasy <code>Fraction</code> bdcy iloczynem liczby 
  * cakowitej typu <code>int</code> i obiektu <code>Fraction</code>.
  * @param m liczba cakowita typu <code>int</code>.
  * @param x obiekt klasy <code>Fraction</code>,
  */
    public static Fraction prod(int m, Fraction x) {
        return x.mult(m);
    }
    
/** Zwraca obiekt klasy <code>Fraction</code> reprezentujcy iloczyn 
  * dwch liczb cakowitych typu <code>int</code>.
  * @param m liczba cakowita typu <code>int</code>,
  * @param n liczba cakowita typu <code>int</code>.
  */
    public static Fraction prod(int m, int n) {
        return new Fraction(m).mult(n);
    }
    
/** Zwraca obiekt <code>Fraction</code> reprezentujcy odwrotno uamka 
  * zawartego w obiekcie wywoujcym t metod.
  * @throws IllegalArgumentException gdy ten obiekt reprezentuje uamek 
  * <code>0/1</code>.
  */
    public Fraction multInv() {
        return new Fraction(this.den, this.num);
    }
 
/** Zwraca obiekt <code>Fraction</code> reprezentujcy odwrotno uamka 
  * zawartego w obiekcie <code>x</code> podanym jako parametr.
  * @param x obiekt klasy <code>Fraction</code>.
  * @throws IllegalArgumentException gdy obiekt <code>x</code> 
  * reprezentuje uamek <code>0/1</code>.
  */
    public static Fraction multInv(Fraction x) {
        return new Fraction(x.den, x.num);
    }
    
/** Zwraca nowy obiekt <code>Fraction</code> - iloraz uamka zawartego
  * w obiekcie wywoujcym metod (dzielna) i uamka reprezentowanego 
  * przez obiekt przekazany jako parametr (dzielnik).
  * @param x uamek, obiekt klasy <code>Fraction</code> (dzielnik).
  * @throws ArithmeticException gdy obiekt <code>x</code> reprezentuje 
  * <code>0/1</code>.
  */
    public Fraction div(Fraction x) {
        if (x.num == 0)
            throw new ArithmeticException("Dzielenie przez 0!");
        return new Fraction(this.num*x.den, this.den*x.num).reduce();
    }

/** Zwraca nowy obiekt <code>Fraction</code> - iloraz uamka zawartego
  * w obiekcie wywoujcym metod (dzielna) i liczby cakowitej typu 
  * <code>int</code> przekazanej jako parametr (dzielnik).
  * @param m liczba cakowita typu <code>int</code> (dzielnik).
  * @throws ArithmeticException gdy podamy <code>m = 0</code>.
  */
    public Fraction div(int m) {
        if (m == 0)
            throw new ArithmeticException("Dzielenie przez 0!");
        return new Fraction(this.num, this.den*m).reduce();
    }
    
/** Zwraca obiekt klasy <code>Fraction</code> bdcy ilorazem dwch 
  * obiektw <code>Fraction</code>.
  * @param x obiekt klasy <code>Fraction</code> (dzielna),
  * @param y obiekt klasy <code>Fraction</code> (dzielnik).
  * @throws ArithmeticException gdy obiekt <code>y</code> reprezentuje 
  * <code>0/1</code>.
  */
    public static Fraction quot(Fraction x, Fraction y) {
        if (y.num == 0)
            throw new ArithmeticException("Dzielenie przez 0!");
        return x.div(y);
    }

/** Zwraca obiekt klasy <code>Fraction</code> bdcy ilorazem obiektu 
  * <code>Fraction</code> (dzielna) i liczby cakowitej typu 
  * <code>int</code> (dzielnik).
  * @param x obiekt klasy <code>Fraction</code> (dzielna),
  * @param m liczba cakowita typu <code>int</code> (dzielnik).
  * @throws ArithmeticException gdy podamy <code>m = 0</code>.
  */
    public static Fraction quot(Fraction x, int m) {
     if (m == 0)
         throw new ArithmeticException("Dzielenie przez 0!");
        return x.div(m);
    }

/** Zwraca obiekt klasy <code>Fraction</code> bdcy ilorazem liczby 
  * cakowitej typu <code>int</code> (dzielna) i obiektu 
  * <code>Fraction</code> (dzielnik).
  * @param m liczba cakowita typu <code>int</code> (dzielna).
  * @param x obiekt klasy <code>Fraction</code> (dzielnik).
  * @throws ArithmeticException gdy obiekt <code>x</code> reprezentuje 
  * <code>0/1</code>.
  */
    public static Fraction quot(int m, Fraction x) {
        if (x.num == 0)
            throw new ArithmeticException("Dzielenie przez 0!");
        return new Fraction(m).div(x);
    }

/** Zwraca obiekt klasy <code>Fraction</code> reprezentujcy iloraz 
  * dwch liczb cakowitych typu <code>int</code>.
  * @param m liczba cakowita typu <code>int</code> (dzielna),
  * @param n liczba cakowita typu <code>int</code> (dzielnik).
  * @throws ArithmeticException gdy podamy <code>n = 0</code>.
  */
    public static Fraction quot(int m, int n) {
        if (n == 0)
            throw new ArithmeticException("Dzielenie przez 0!");
        return new Fraction(m, n).reduce();
    }
 
/** Zwraca najmniejsz wspln wielokrotno pary liczb cakowitych 
  * dodatnich <code>m</code> i <code>n</code>, podanych jako parametry 
  * wywoania metody. 
  * @param m liczba cakowita dodatnia,
  * @param n liczba cakowita dodatnia.
  */
    private int nww(int m, int n) {
        int wm = m;
        int wn = n;
        while (wm != wn) 
            if (wm > wn) 
                wn += n; 
            else 
                wm += m;
        return wm;
    }
       
/** Zwraca nowy obiekt <code>Fraction</code> - sum obiektu wywoujcego 
  * t metod i obiektu przekazanego jako parametr.
  * @param x uamek, obiekt klasy <code>Fraction</code>.
  */
    public Fraction add(Fraction x) {
        if (this.den == x.den)
            return new Fraction(this.num+x.num, this.den).reduce();
        else {
            int wm = nww(this.den, x.den);
            return new Fraction(wm/this.den*this.num+wm/x.den*x.num, wm).reduce();
        }
    }
    
/** Zwraca nowy obiekt <code>Fraction</code> - sum obiektu wywoujcgo 
  * t metod i liczby cakowitej przekazanej jako parametr.
  * @param m liczba cakowita typu <code>int</code>.
  */
    public Fraction add(int m) {
        return new Fraction(this.num+m*this.den, this.den).reduce();
    }
    
/** Zwraca obiekt klasy <code>Fraction</code> bdcy sum dwch 
  * obiektw <code>Fraction</code>.
  * @param x obiekt klasy <code>Fraction</code>,
  * @param y obiekt klasy <code>Fraction</code>.
  */
    public static Fraction sum(Fraction x, Fraction y) {
        return x.add(y);
    }

/** Zwraca obiekt klasy <code>Fraction</code> bdcy sum obiektu 
  * <code>Fraction</code> i liczby cakowitej typu <code>int</code>.
  * @param x obiekt klasy <code>Fraction</code>,
  * @param m liczba cakowita typu <code>int</code>.
  */
    public static Fraction sum(Fraction x, int m) {
        return x.add(m);
    }
    
/** Zwraca obiekt klasy <code>Fraction</code> bdcy sum liczby 
  * cakowitej typu <code>int</code> i obiektu <code>Fraction</code>.
  * @param m liczba cakowita typu <code>int</code>.
  * @param x obiekt klasy <code>Fraction</code>,
  */
    public static Fraction sum(int m, Fraction x) {
        return x.add(m);
    }
    
/** Zwraca obiekt klasy <code>Fraction</code> reprezentujcy sum 
  * dwch liczb cakowitych typu <code>int</code>.
  * @param m liczba cakowita typu <code>int</code>,
  * @param n liczba cakowita typu <code>int</code>.
  */
    public static Fraction sum(int m, int n) {
        return new Fraction(m+n);
    }
    
/** Zwraca obiekt <code>Fraction</code> reprezentujcy uamek przeciwny 
  * do uamka zawartego w obiekcie wywoujcym t metod.
  */
    public Fraction addInv() {
        return new Fraction(-this.num, this.den);
    }
 
/** Zwraca obiekt <code>Fraction</code> reprezentujcy uamek przeciwny 
  * do uamka zawartego w obiekcie <code>x</code> podanym jako parametr.
  * @param x obiekt klasy <code>Fraction</code>.
  */
    public static Fraction addInv(Fraction x) {
        return new Fraction(-x.num, x.den);
    }
    
/** Zwraca nowy obiekt <code>Fraction</code> - rnic obiektu 
  * wywoujcgo t metod i obiektu przekazanego jako parametr.
  * @param x uamek, obiekt klasy <code>Fraction</code>.
  */
    public Fraction sub(Fraction x) {
        if (this.den == x.den)
            return new Fraction(this.num-x.num, this.den).reduce();
        else {
            int wm = nww(this.den, x.den);
            return new Fraction(wm/this.den*this.num-wm/x.den*x.num, wm).reduce();
        }
    }

/** Zwraca nowy obiekt <code>Fraction</code> - rnic obiektu 
  * wywoujcgo t metod (odjemna) i liczby cakowitej przekazanej jako 
  * parametr (odjemnik).
  * @param m liczba cakowita typu <code>int</code> (odjemnik).
  */
    public Fraction sub(int m) {
        return new Fraction(this.num-m*this.den, this.den).reduce();
    }

    
/** Zwraca obiekt klasy <code>Fraction</code> bdcy rnic dwch 
  * obiektw <code>Fraction</code>.
  * @param x obiekt klasy <code>Fraction</code> (odjemna),
  * @param y obiekt klasy <code>Fraction</code> (odjemnik).
  */
    public static Fraction diff(Fraction x, Fraction y) {
        return x.sub(y);
    }

/** Zwraca obiekt klasy <code>Fraction</code> bdcy rnic obiektu 
  * <code>Fraction</code> (odjemna) i liczby cakowitej typu 
  * <code>int</code> (odjemnik).
  * @param x obiekt klasy <code>Fraction</code> (odjemna),
  * @param m liczba cakowita typu <code>int</code> (odjemnik).
  */
    public static Fraction diff(Fraction x, int m) {
        return x.sub(m);
    }

/** Zwraca obiekt klasy <code>Fraction</code> bdcy rnic liczby 
  * cakowitej typu <code>int</code> (odjemna) i obiektu 
  * <code>Fraction</code> (odjemnik).
  * @param m liczba cakowita typu <code>int</code> (odjemna),
  * @param x obiekt klasy <code>Fraction</code> (odjemnik).
  */
    public static Fraction diff(int m, Fraction x) {
        return x.sub(m).addInv();
    }

/** Zwraca obiekt klasy <code>Fraction</code> reprezentujcy rnic 
  * dwch liczb cakowitych typu <code>int</code>.
  * @param m liczba cakowita typu <code>int</code> (odjemna),
  * @param n liczba cakowita typu <code>int</code> (odjemnik).
  */
    public static Fraction diff(int m, int n) {
        return new Fraction(m-n);
    }
    
/** Zwraca warto licznika uamka reprezentowanego przez obiekt.
  */ 
    public int getNum() {
	    return this.num;
    } 
/** Zwraca warto mianownika uamka reprezentowanego przez obiekt.
  */ 
    public int getDen() {
	    return this.den;
    }
/** Ustawia warto licznika uamka reprezentowanego przez obiekt. 
  * @param m liczba cakowita typu <code>int</code>, nowa warto 
  * licznika uamka reprezentowanego przez obiekt.
  */ 
    public Fraction setNum(int m) {
        this.num = m;
        return this;
    } 

/** Ustawia warto mianownika uamka.
  * @param  n liczba cakowita dodatnia typu <code>int</code>, nowa 
  * warto mianownika uamka reprezentowanego przez obiekt.
  * @throws IllegalArgumentException gdy podamy mianownik ujemny lub 
  * rwny 0. 
  */ 
    public Fraction setDen(int n) {
        if (n > 0) {
            this.den = n;
            return this;
        } else
            throw new IllegalArgumentException("Parametr n <= 0!");
    }

/** Ustawia warto licznika i mianownika uamka.
  * @param m liczba cakowita typu <code>int</code>, nowa warto 
  * licznika uamka reprezentowanego przez obiekt.
  * @param  n liczba cakowita dodatnia typu <code>int</code>, nowa 
  * warto mianownika uamka reprezentowanego przez obiekt.
  * @throws IllegalArgumentException gdy podany mianownik ujemny lub
  * rwny 0. 
  */ 
    public Fraction setFrac(int m, int n) {
        if (n > 0) {
            this.num = m;
            this.den = n;
            return this;
        } else
            throw new IllegalArgumentException("Parametr n <= 0!");
    }
/** Porwnuje obiekt klasy <code>Fraction</code> (wywoujcy t metod) 
  * z dowolnym innym obiektem i zwraca warto <code>true</code>, gdy 
  * obiekty s tego samego typu i reprezentuj t sam warto (uamek).
  * Metoda przesania metod <code>Object.equals()</code>.
  */
    @Override public boolean equals(Object o) {
       if (this == o)
           return true;
       if (o == null || !(o instanceof Fraction))
           return false;
       Fraction c = (Fraction) o;
       /*
       if (this.num*c.den == this.den*c.num)
           return true;
       else
           return false;
       */
       Fraction d = new Fraction(this); 
       c.reduce();
       d.reduce();
       if (d.num == c.num && d.den == c.den)
           return true;
       else
           return false;
    }
/** Zwraca haszkod obiektu.
  */    
    @Override public int hashCode() {
        int d = nwd(num, den);
        int result = 17;
        result = 31*result+num/d;
        result = 31*result+den/d;
        return result;
    }

/** Zwraca warto dziesitn typu <code>double</code> uamka
  * repezentowanego przez obiekt wywoujcy t metod. 
  */
    public double doubleValue() {
        return (double)this.num/this.den;
    }

/** Zwraca warto dziesitn typu <code>float</code> uamka
  * repezentowanego przez obiekt wywoujcy t metod. 
  */
    public float floatValue() {
        return (float)this.num/this.den;
    }

/** Zwraca warto dziesitn typu <code>double</code> uamka
  * repezentowanego przez obiekt podany jako parametr. 
  * @param x obiekt typu <code>Fraction</code>.
  */
    public static double toDouble(Fraction x) {
        return (double)x.num/x.den;
    }

/** Zwraca warto dziesitn typu <code>float</code> uamka
  * repezentowanego przez obiekt podany jako parametr. 
  * @param x obiekt typu <code>Fraction</code>.
  */
    public static float toFloat(Fraction x) {
        return (float)x.num/x.den;
    }
/** Tworzy nowy obiekt <code>Fraction</code> - uamek na 
  * podstawie acucha znakw postaci "4/7", "5" "2.45" lub "2,45".
  * @param str acuch znakw postaci "4/7", "5" "2.45" lub "2,45".
  * @throws NumberFormatException gdy podamy acuch znakw nie 
  * przedstawia uamka zwykego lub dziesitnego.
  * @throws ArithmeticException gdy mianownik jest 0 (<code>"1/0"</code>).
  */
    public Fraction(String str) {
        int i = str.indexOf('.');
        if (i == -1)
            i = str.indexOf(',');
        if (i == -1) { 
            i = str.indexOf('/');
            if (i == -1) {
                this.num = Integer.parseInt(str);
                this.den = 1;
            } else {
                this.num = Integer.parseInt(str.substring(0, i));
                this.den = Integer.parseInt(str.substring(i+1));
                if (this.den == 0)
                    throw new ArithmeticException("Dzielenie przez 0!");
            }
        } else {
            this.num = Integer.parseInt(str.substring(0, i)+str.substring(i+1));
            int k = str.length()-i;
            this.den = 1;
            int n = 1;
            while (n++ < k)
                this.den *= 10;
        }
        this.correction();
        this.reduce();
    }
    
/** Zwraca obiekt klasy <code>Fraction</code> reprezentujcy okrelon 
  * warto typu <code>float</code>.
  * @param x liczba zmiennoprzecinkowa typu <code>float</code>.
  */ 
    public static Fraction valueOf(float x) {
        return new Fraction(""+x);
    }

/** Zwraca obiekt klasy <code>Fraction</code> reprezentujcy okrelon 
  * warto typu <code>double</code>.
  * @param x liczba zmiennoprzecinkowa typu <code>double</code>.
  */ 
    public static Fraction valueOf(double x) {
        return new Fraction(""+x);
    }

/** Zwraca obiekt klasy <code>Fraction</code> reprezentujcy okrelon 
  * warto typu cakowitego <code>int</code>.
  * @param m liczba cakowita.
  */
    public static Fraction valueOf(int m) {
        return new Fraction(m);
    }

/** Zwraca obiekt klasy <code>Fraction</code> reprezentujcy uamek 
  * <code>m/n</code> na podstawie wartoci cakowitych parametrw 
  * <code>m</code> i <code>n</code>.
  * @param m liczba cakowita (licznik uamka),
  * @param n liczba cakowita (mianownik uamka).
  * @throws IllegalArgumentException gdy podamy mianownik n = 0.
  */
    public static Fraction valueOf(int m, int n) {
        if (n != 0) 
            return new Fraction(m, n).reduce();
        else
            throw new IllegalArgumentException("Parametr n = 0!");
    }

/** Zwraca obiekt klasy <code>Fraction</code> na podstawie acucha 
  * znakw przedstawiajcego uamek dziesitny lub zwyky.
  * @param str acuch znakw przedstawiajcy uamek dziesitny "0.12", 
  * "0,12" lub zwyky "2/3".
  * @throws NumberFormatException wystpi wyjtek, gdy parametr 
  * <code>str</code> nie jest liczb cakowit lub uamkiem dziesitnym 
  * (zapis w notacji naukowej nie jest interpretowany).
  */
    public static Fraction valueOf(String str) {
        return new Fraction(str);
    }

}