import java.text.DecimalFormat;
import java.text.NumberFormat;
public class PolarComplex {
    private double r, fi;
    
    public PolarComplex() {}
    
    public PolarComplex(double r, double fi) {
	    if (r < 0)
	        throw new ArithmeticException("Niewaciwy parametr: "+r);
	    this.r = r;
	    this.fi = fi;
    }
    
    public PolarComplex(double r) {
	    this.r = Math.abs(r); 
	    if (r >= 0.0)
	        this.fi = 0.0;
	    else
	        this.fi = -Math.PI;
    }
    
    public Complex toComplex() {
	    return new Complex(r*Math.cos(fi), r*Math.sin(fi));
    }
    
    @Override public String toString() {
	    NumberFormat formatter = new DecimalFormat("#0.000000");
	    String s1 = formatter.format(this.r);
        String s2 = formatter.format(this.fi);
        return "[r="+s1+"; fi="+s2+"]";
	}
	
    public PolarComplex(PolarComplex z) {
	    r = z.r; 
	    fi = z.fi;
    }
    
    public PolarComplex(Complex z) {
	    r = z.abs(); 
	    fi = z.arg();
    }
    
    public PolarComplex mult(PolarComplex z) {
	    return new PolarComplex(this.r*z.r, this.fi+z.fi);
    }
    
    public PolarComplex div(PolarComplex z) {
	    return new PolarComplex(this.r/z.r, this.fi-z.fi);
    }
    
    public PolarComplex sqr() {
	    return new PolarComplex(r*r, 2*fi);
    }
    
    public PolarComplex cube() {
	    return new PolarComplex(r*r*r, 3*fi);
    }
    
    public PolarComplex power(int n) {
	    return new PolarComplex(Math.pow(r, n), n*fi);
    }
    
    public PolarComplex sqrt(int k) {
	    k %= 2;
	    return new PolarComplex(Math.sqrt(r), fi/2+k*Math.PI);
    }
    
    public PolarComplex cbrt(int k) {
	    k %= 3;
	    return new PolarComplex(Math.cbrt(r), (fi+2*k*Math.PI)/3);
    }
    
    public Complex[] sqrt() {
	    Complex[] tmp = new Complex[2];
	    tmp[0] = new PolarComplex(Math.sqrt(r), fi/2).toComplex();
	    tmp[1] = new PolarComplex(Math.sqrt(r), fi/2+Math.PI).toComplex();
	    return tmp;
    }
    
    public Complex[] cbrt() {
	    Complex[] tmp = new Complex[3];
	    tmp[0] = new PolarComplex(Math.cbrt(r), fi/3).toComplex();
	    tmp[1] = new PolarComplex(Math.cbrt(r), (fi+2*Math.PI)/3).toComplex();
	    tmp[2] = new PolarComplex(Math.cbrt(r), (fi+4*Math.PI)/3).toComplex();
	    return tmp;
    }
    
    public PolarComplex root(int n, int k) {
	    k %= n;
	    return new PolarComplex(Math.pow(r, 1.0/n), (fi+2*k*Math.PI)/n);
    }
    
    public Complex[] root(int n) {
	    Complex[] tmp = new Complex[n];
	    for(int k = 0; k < n; ++k) {
		    tmp[k] = new PolarComplex(Math.pow(r, 1.0/n), (fi+2*k*Math.PI)/n).toComplex();
	    }
	    return tmp;
    }
/* =================================================== */    
/* Metody */
    
    

    
    
    
    
    
    
    public double abs() {
	    return r;
    }
    public double arg() {
	    return fi;
    }
    public void print() {
	    System.out.print(r+"(cos("+fi+")+isin("+fi+"))");
    }
    public void print(String s) {
	    System.out.print(s+r+"(cos("+fi+")+isin("+fi+"))");
    }
    public void println() {
	    System.out.println(r+"(cos("+fi+")+isin("+fi+"))");
    }
    public void println(String s) {
	    System.out.println(s+r+"(cos("+fi+")+isin("+fi+"))");
    }
    public void printExp() {
	    System.out.print(r+"exp(i"+fi+")");
    }
    public void printlnExp() {
	    System.out.println(r+"exp(i"+fi+")");
    }
    public void printExp(String s) {
	    System.out.print(s+r+"exp(i"+fi+")");
    }
    public void printlnExp(String s) {
	    System.out.println(s+r+"exp(i"+fi+")");
    }
    /* Metody statyczne */
    
    public static PolarComplex valueOf(Complex z) {
	    //return new PolarComplex(z.abs(), z.arg());
	    return z.toPolarComplex();
    }
    
    public static PolarComplex sqr(PolarComplex z) {
	    return new PolarComplex(z.r*z.r, 2*z.fi);
    }
    public static PolarComplex cube(PolarComplex z) {
	    return new PolarComplex(z.r*z.r*z.r, 3*z.fi);
    }
    public static PolarComplex power(PolarComplex z, int n) {
	    return new PolarComplex(Math.pow(z.r, n), n*z.fi);
    }
    
    public static PolarComplex sqrt(PolarComplex z, int k) {
	    k %= 2;
	    return new PolarComplex(Math.sqrt(z.r), z.fi/2+k*Math.PI);
    }
    public static PolarComplex cbrt(PolarComplex z, int k) {
	    k %= 3;
	    return new PolarComplex(Math.cbrt(z.r), (z.fi+2*k*Math.PI)/3);
    }
    public static PolarComplex root(PolarComplex z, int n, int k) {
	    k %= n;
	    return new PolarComplex(Math.pow(z.r, 1.0/n), (z.fi+2*k*Math.PI)/n);
    }
    public static PolarComplex prod(PolarComplex x, PolarComplex y) {
	    return new PolarComplex(x.r*y.r, x.fi+y.fi);
    }
    public static PolarComplex quot(PolarComplex x, PolarComplex y) {
	    return new PolarComplex(x.r/y.r, x.fi-y.fi);
    }
}