public class Complex {
    private double re, im;
    
    public Complex() {}
    
    public Complex(double x) {
	    this.re = x; 
	    this.im = 0;
    }
    
    public Complex(double x, double y) {
	    this.re = x; 
	    this.im = y;
    }
     /* Zmiana wartoci czci rzeczywistej liczby zespolonej */
    public void setRe(double x) {
	    this.re = x;
    }
    /* Zmiana wartoci czci urojonej liczby zespolonej */
    public void setIm(double x) {
	    this.im = x;
    }
    
    @Override public String toString() {
	    StringBuffer tmp = new StringBuffer();
	    tmp.append(re);
	    if (im > 0) {
	        tmp.append("+");
	        tmp.append(im);
	        tmp.append("i");
        } else if (im < 0) {
	        tmp.append(im);
	        tmp.append("i");
        }
        return tmp.toString();
	}
	
    public Complex add(Complex x) {
		return new Complex(this.re+x.re, this.im+x.im);
	}
	
	public Complex sub(Complex x) {
		return new Complex(this.re-x.re, this.im-x.im);
	}
	
	public Complex opp() {
		return new Complex(-re, -im);
	}
	
	public Complex conj() {
		return new Complex(re, -im);
	}
	
	public Complex rec() {
		double sc = re*re+im*im;
		return new Complex(re/sc, -im/sc);
	}
	
	public Complex mult(Complex x) {
		return new Complex(re*x.re-im*x.im, re*x.im+im*x.re);
	}
	
	public Complex div(Complex x) {
		return this.mult(x.rec());
	}
    
	public static final Complex ZERO = new Complex();
    public static final Complex ONE = new Complex(1);
    public static final Complex I = new Complex(0, 1);
    
    public double abs() {
		return Math.sqrt(re*re+im*im);
	}
	
	public double arg() {
	    return Math.atan2(im, re);
	}
    
	public double getRe() {
		return re;
	}
	
	public double getIm() {
		return im;
	}
	
	public void print() {
		System.out.print(this);
	}
	
	public void print(String str) {
		System.out.print(str+this);
	}
	
	public void println() {
		System.out.println(this);
	}
	
	public void println(String str) {
		System.out.println(str+this);
	}
	
	public Complex(Complex z) {
	    re = z.re; 
	    im = z.im;
    }
    
	public boolean equals(Complex z) {
		return re == z.re && im == z.im;
	}
	
	@Override public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || !(o instanceof Complex))
            return false;
        Complex c = (Complex) o;
        if (this.re == c.re && this.im == c.im)
            return true;
        else
            return false;
    }
    
    @Override public int hashCode() {
        int result = 17;
        long tmp = Double.doubleToLongBits(re);
        result = 31*result+(int)(tmp^(tmp>>>32));
        tmp = Double.doubleToLongBits(im);
        result = 31*result+(int)(tmp^(tmp>>>32));
        return result;
    }

    public Complex(String s) { 
        int n = s.indexOf("i");
        if (n == -1) {  // nie ma jednostki urojonej - liczba rzeczywista
            re = Double.parseDouble(s);
            im = 0;
        } else {
            // jest jednostka urojona
            if (n == s.length()-1) {
                // i jest ostatnim znakiem
                s = s.substring(0, s.length()-1);
                if (s.isEmpty() || s.equals("+")) {// liczba "i" lub "+i"
                    re = 0; im = 1; return;
                }
                if (s.equals("-")) {               // liczba "-i"
                    re =0; 
                    im = -1; 
                    return;
                }
                int znakPlus = s.lastIndexOf("+");
                if (znakPlus == s.length()-1) {    // liczba "a+i" lub bd
                    re = Double.parseDouble(s.substring(0, znakPlus));
                    im = 1;
                    return;
                }
                int znakMinus = s.lastIndexOf("-");  
                if (znakMinus == s.length()-1) {   // liczba "a-i" lub bd
                    re = Double.parseDouble(s.substring(0, znakMinus));
                    im = -1;
                    return;
                } 
                if (znakPlus == -1 && znakMinus == -1) {// "bi" lub bd
                    re = 0; 
                    im = Double.parseDouble(s); 
                    return;
                } else if (znakMinus > 0 || znakPlus > 0) {
                    if (znakMinus > 0) {
                        // liczba postaci "-2-3i", "+2-3i", "2-3i" lub bd
                        re = Double.parseDouble(s.substring(0, znakMinus));
                        im = Double.parseDouble(s.substring(znakMinus));
                        return;
                    }  
                    if (znakPlus > 0) {
                        // liczba postaci "-2+3i", "+2+3i", "2+3i" lub bd
                        re = Double.parseDouble(s.substring(0, znakPlus));
                        im = Double.parseDouble(s.substring(znakPlus));
                        return;
                    }
                }  
            } else // i nie jest ostatnim znakiem - bdne dane
                throw new ArithmeticException("Bdna liczba: "+s);
        }
    }
    
    public static Complex power(Complex a, int n) {
        Complex p = Complex.ONE;
        if (n > 0) 
            for(int i = 0; i < n; ++i)
                p = p.mult(a);
        else if (n < 0)
            for(int i = 0; i < -n; ++i)
                p = p.div(a);
        return p;
    }
    
    public Complex power(int n) {
        Complex p = Complex.ONE;
        if (n > 0) 
            for(int i = 0; i < n; ++i)
                p = p.mult(this);
        else if (n < 0)
            for(int i = 0; i < -n; ++i)
                p = p.div(this);
        return p;
    }
		
    public Complex sqr() {
		return this.mult(this);
	}
	
	public Complex sqrt() {
		if (im == 0) 
			if (re >= 0)
			    return new Complex(Math.sqrt(re));
			else 
			    return new Complex(0.0, Math.sqrt(-re));
		else 
			return new Complex(Math.sqrt((abs()+re)/2), Math.signum(im)*Math.sqrt((abs()-re)/2));		
	}
	
	public Complex nextSqrt() {
		return this.sqrt().opp();
	}

    public void printf() {
		System.out.printf("%f%+fi", this.re, this.im);
	}
	
	public void printf(String str) {
		System.out.printf(str+"%f%+fi", this.re, this.im);
	}
	
	public void printlnf() {
		System.out.printf("%f%+fi\n", this.re, this.im);
	}
	
	public void printlnf(String str) {
		System.out.printf(str+"%f%+fi\n", this.re, this.im);
	}
	
	public static Complex sum(Complex x, Complex y) {
		return new Complex(x.re+y.re, x.im+y.im);
	}
	
	public static Complex diff(Complex x, Complex y) {
		return new Complex(x.re-y.re, x.im-y.im);
	}
	
	public static Complex prod(Complex x, Complex y) {
		return new Complex(x.re*y.re-x.im*y.im, x.re*y.im+x.im*y.re);
	}
	
	public static Complex quot(Complex x, Complex y) {
		double s = x.re*x.re+y.re*y.re;
		return new Complex((x.re*y.re+x.im*y.im)/s, (x.im*y.re-x.re*y.im)/s);
	}
	
	public Complex(PolarComplex z) {
	    Complex tmp = z.toComplex();
	    this.re = tmp.re;
	    this.im = tmp.im;
    }
    
    public PolarComplex toPolarComplex() {
	    return new PolarComplex(this.abs(), this.arg());
    }
 /*================================ do poprawki =======*/	
	/* metody statyczne */
	public static Complex parseComplex(String s) {
		return new Complex(s);
    }
    public static Complex valueOf(PolarComplex z) {
	    return z.toComplex();
    }
    
    public static Complex sqrt(Complex z) {
		if (z.im == 0) 
			if (z.re >= 0)
			    return new Complex(Math.sqrt(z.re));
			else 
			    return new Complex(0.0, Math.sqrt(-z.re));
		else 
			return new Complex(Math.sqrt((z.abs()+z.re)/2), Math.signum(z.im)*Math.sqrt((z.abs()-z.re)/2));		
	}
	
	public static Complex nextSqrt(Complex z) {
		return sqrt(z).opp();
	}
	
	public static Complex sqr(Complex z) {
		return z.mult(z);
	}
}