/** Zadanie Z22.4 */
final class RN {
    protected final String r;
    protected final int d;
    private RN(String r, int d) {
        this.r = r; this.d = d;
    };
    static final RN[] rn = {new RN("M", 1000), new RN("CM", 900), 
        new RN("D", 500), new RN("CD", 400),  new RN("C", 100), 
        new RN("XC", 90), new RN("L", 50), new RN("XL", 40), 
        new RN("X", 10), new RN("IX", 9), new RN("V", 5), 
        new RN("IV", 4), new RN("I", 1)};
}

public class Z22_4 {
       
	private static String decToRoman(int n) {
		if (n < 1 || n > 3999)
		    throw new ArithmeticException("Liczba poza zakresem: "+n);
		StringBuilder tmp = new StringBuilder("");
		for(int i = 0; i<13; ++i) {
            while (n >= RN.rn[i].d) {
                n -= RN.rn[i].d;
                tmp.append(RN.rn[i].r);
            }
        } 
        return tmp.toString();           
	}
	    
	public static void main(String args[]) {
		System.out.println("Potgi liczby 2 w systemie rzymskim");
		int i = 0, n = 1; 
		while (i < 13) {
			System.out.println("2^"+i+" = "+decToRoman(n));
			++i;
			n *= 2;
		} 
    }
}
