/** Zadanie Z26.9 */
import java.util.Arrays;
public class Polynomial {
    private double[] w;
    private static double[] korekta(double[] a) {
		int n = a.length;
		while (a[n-1] == 0 && n > 1) --n;
		return Arrays.copyOf(a, n);
	} 
    public Polynomial(double[] a) {
	    a = korekta(a);
	    w = new double[a.length];
	    for(int i = 0; i < a.length; ++i)
	        this.w[i] = a[i];    
    } 
    @Override public String toString() {
	    return Arrays.toString(this.w);
    }
    public double horner(double x) {
		double y = 0.0;
		for(int i = w.length-1; i >= 0; --i) {
			y *= x;
			y += w[i];
		}
		return y;
    }
    public Polynomial add(Polynomial a) {
	    double[] s = new double[Math.max(this.w.length, a.w.length)];
		int i = 0;
		for(i = 0; i < Math.min(this.w.length, a.w.length); ++i) 
		    s[i] = this.w[i]+a.w[i];
		if (this.w.length > a.w.length)
		    while (i < this.w.length) {
			    s[i] = this.w[i];
			    ++i;
		    } 
		else if (this.w.length < a.w.length)
		    while (i < a.w.length) {
			    s[i] = a.w[i];
			    ++i;
		    }
		else if(s[s.length-1] == 0) 
			korekta(s);
		return new Polynomial(s);
    }
    public Polynomial sub(Polynomial a) {
	    double[] s = new double[Math.max(this.w.length, a.w.length)];
		int i = 0;
		for(i = 0; i < Math.min(this.w.length, a.w.length); ++i) 
		    s[i] = this.w[i]-a.w[i];
		if (this.w.length > a.w.length)
		    while (i < this.w.length) {
			    s[i] = this.w[i];
			    ++i;
		    } 
		else if (this.w.length < a.w.length)
		    while (i < a.w.length) {
			    s[i] = -a.w[i];
			    ++i;
		    }
		else if(s[s.length-1] == 0) 
			korekta(s);
		return new Polynomial(s);
    }
    public Polynomial mult(double a) {
	    double[] tmp = new double[w.length];
		for(int i = 0; i < w.length; ++i) 
		    tmp[i] = this.w[i]*a;
		return new Polynomial(tmp);
    }
    public Polynomial mult(Polynomial a) {
	    double[] tmp = new double[this.w.length+a.w.length-1];
		for(int i = 0; i < this.w.length; ++i) 
		    for(int j = 0; j < a.w.length; ++j)
		        tmp[i+j] += this.w[i]*a.w[j];
		return new Polynomial(tmp);
    }
    public Polynomial derivative() {
	    double[] tmp = new double[this.w.length-1];
		for(int i = 0; i < tmp.length; ++i) 
			tmp[i] = this.w[i+1]*(i+1);;
		return new Polynomial(tmp);
    }
    public Polynomial integral() {
	    double[] tmp = new double[this.w.length+1];
		for(int i = 0; i < this.w.length; ++i) 
			tmp[i+1] = this.w[i]/(i+1);
		tmp[0] = 0;
		return new Polynomial(tmp);
    }
    public Polynomial division(int c) {
	    double[] tmp = new double[this.w.length-1];
		int i = tmp.length-1;		
		tmp[i] = this.w[i+1];
		while (i > 0) {
			tmp[i-1] = this.w[i]+tmp[i]*c;
			--i;
		}
		return new Polynomial(tmp);
    }
    public double remainder(int c) {
	    double[] tmp = new double[this.w.length-1];
		int i = tmp.length-1;		
		tmp[i] = this.w[i+1];
		while (i > 0) {
			tmp[i-1] = this.w[i]+tmp[i]*c;
			--i;
		}
		return this.w[i]+tmp[i]*c;
    }
}