import java.util.Scanner;
public class Z28_25 {
	private static Scanner cin = new Scanner(System.in);

    private static void input(double[][] x, double[][] y) {
	    int n = x.length;
	    for(int i = 0; i < n; ++i) {
		    System.out.println("Podaj wspczynniki rwnania");
            for(int j = 0; j < n; ++j) {
                System.out.printf("a[%d][%d] = ", i+1, j+1);
                x[i][j] = cin.nextDouble();
            }
            System.out.printf("b[%d] = ", i+1);
            y[i][0] = cin.nextDouble();
	    }
	}
		
	public static double[][] product (double[][] x, double[][] y) {
		if (x[0].length != y.length)
		    throw new ArithmeticException("Niezgodne wymiary macierzy");
		double[][] tmp = new double[x.length][y[0].length];
		for(int i = 0; i < x.length; ++i) 
            for(int j = 0; j < y[0].length; ++j)
                for(int k = 0; k < y.length; ++k)
                    tmp[i][j] += x[i][k]*y[k][j];
        return tmp;
	}
	
	private static double[][] inverse(double[][] x) {
		if (x.length != x[0].length)
		    throw new ArithmeticException("To nie jest macierz kwadratowa");
		int n = x.length;
		    
	    double[][] tmp = new double[n][n];
	    for(int i = 0; i < n; ++i)
	        for(int j = 0; j < n; ++j)
	            tmp[i][j] = x[i][j];
	            
	    double[][] I = new double[n][n];
	    for(int i = 0; i < n; ++i)
	        I[i][i] = 1.0;
	                  
	    for(int i = 0; i < n; ++i)     
	        for(int j = 0; j < n; ++j)  {
		        if (tmp[i][i] != 0.0) {
			        if (j != i) {
		                double p = tmp[j][i]/tmp[i][i];
		                for(int k = 0; k < n; ++k) {
	                        tmp[j][k] -= tmp[i][k]*p;
	                        I[j][k] -= I[i][k]*p;
                        }
                    }
			        
		        } else {
                    for(int k = i+1; k < n; ++k) {
			            if (tmp[k][i] != 0.0) {
				            for(int m = 0; m < n; ++m) {
					            double temp = tmp[i][m];
					            tmp[i][m] = tmp[k][m];
					            tmp[k][m] = -temp;
					            temp = I[i][m];
					            I[i][m] = I[k][m];
					            I[k][m] = -temp;
				            }
				            break;
			            }    
		            }
                }
            }   
        for(int i = 0; i < n; ++i) 
            if (tmp[i][i] != 0.0) 
                for(int j = 0; j < n; ++j)
                    I[i][j] /= tmp[i][i];  
            else
                throw new ArithmeticException("Macierz odwrotna nie istnieje");   
	    return I;
    }
	
    public static void main(String[] args) { 
	    /* Liczba rwna */
	    int n;
	    do {
		    System.out.print("Podaj liczb rwna ukadu, n = ");
	        n = cin.nextInt();
        } while (n < 2);
	    /* Wprowadzenie wspczynnikw ukadu rwna */
	    double[][] a = new double[n][n];
	    double[][] b = new double[n][1];
        input(a, b);
        /* Obliczanie macierzy odwrotnej i rozwizanie ukadu */
        try {
            double[][] x = product(inverse(a), b);
            System.out.println("Ukad rwna jest oznaczony");
	        for(int i = 0; i < n; ++i) 
	            System.out.printf("x[%d] = %f\n", i+1, x[i][0]);
        } catch (ArithmeticException e) {
	        System.out.println("Ukad sprzeczny lub nieoznaczony");
        }
    }
}