
#include <functional>
#include <string>
#include <iostream>
#include <mutex>
#include <optional>

template <typename F>
class lazy_val {
private:
    F m_computation;

	// W ksice uywamy wartoci i flagi typu Boolean, aby okreli,
	// czy warto zostaa ju wyznaczona. W tej implementacji uywamy konstrukcji std::optional
	// zachowujcej si jak kontener, ktry moe by pusty lub zawiera pojedyncz warto -
	// czyli dokadnie w taki sposb, jaki prbowalimy zasymulowa za pomoc pary warto/flaga Boolean.
	// Opcjonalne wartoci zostan omwione bardziej szczegowo w rozdziale 9.
    mutable std::optional<decltype(m_computation())> m_value;
    mutable std::mutex m_value_lock;

public:
    lazy_val(F function)
        : m_computation(function)
    {
    }

    lazy_val(lazy_val &&other)
        : m_computation(std::move(other.m_computation))
    {
    }

    operator decltype(m_computation()) () const
    {
        std::lock_guard<std::mutex> lock(m_value_lock);

        if (!m_value) {
            m_value = std::invoke(m_computation);
        }

        return *m_value;
    }

};

template <typename F>
lazy_val<F> make_lazy_val(F &&function)
{
    return lazy_val<F>(std::forward<F>(function));
}

// Zamiast tworzy funkcj make_lazy_val_helper moemy zdefiniowa sowo kluczowe "lazy"
// za pomoc niewielkiej sztuczki zwizanej z makrami:
// makro wywoa operatora minus i utworzy nagwek wyraenia lambda.
// Podczas tworzenia leniwej wartoci dostarczymy tylko ciao wyraenia lambda 

struct _make_lazy_val_helper {
    template <typename F>
    auto operator - (F &&function) const
    {
        return lazy_val<F>(function);
    }
} make_lazy_val_helper;

#define lazy make_lazy_val_helper - [=]


int main(int argc, char *argv[])
{
    setlocale(LC_ALL, "polish");

    int number = 6;

    auto val = lazy {
        std::cout << "Obliczanie odpowiedzi..." << std::endl;
        std::cout << "w przypadku, gdy liczba wynosi: " << number << std::endl;
        return 42;
    };

    number = 2;

    std::cout << "Warto leniwa jest zdefiniowana" << std::endl;

    std::cout << val << std::endl;
}

