
#include <string>
#include <iostream>
#include <vector>
#include <algorithm>

#include "../../common/person.h"

std::string name(const person_t &person)
{
    return person.name();
}

bool is_female(const person_t &person)
{
    return person.gender() == person_t::female;
}

bool is_not_female(const person_t &person)
{
    return !is_female(person);
}

int main(int argc, char *argv[])
{
    std::vector<person_t> people {
        { "Dawid",  person_t::male   },
        { "Janina", person_t::female },
        { "Marta",  person_t::female },
        { "Piotr",  person_t::male   },
        { "Renata", person_t::female },
        { "Tomasz", person_t::male   }
    };

    // Filtrowanie kolekcji przez kopiowanie (patrz punkt 2.2.5)
    std::vector<person_t> females;

    // Algorytm std::copy_if kopiuje do docelowej kolekcji te elementy,
    //  ktre speniaj predykat is_female
    std::copy_if(people.cbegin(), people.cend(),
                 std::back_inserter(females),
                 is_female);

    // Transformacja w celu uzyskania imion
    std::vector<std::string> names(females.size());

    std::transform(females.cbegin(), females.cend(),
                   names.begin(),
                   name);

    for (const auto& name: names) {
        std::cout << name << '\n';
    }

    return 0;
}
