
#include <functional>
#include <string>
#include <iostream>
#include <vector>
#include <algorithm>
#include <random>

template < typename BeginIt
         , typename EndIt
         , typename MidIt
         >
void sort_until(BeginIt begin, MidIt mid, EndIt end)
{
    // Algorytm "std::nth_element" jest algorytmem czciowego sortowania.
    //
    // Po wykonaniu algorytmu element w pozycji "mid" bdzie elementem,
	// ktry znajdowaby si w tej pozycji,
	// gdyby kolekcja zostaa w peni posortowana.
    std::nth_element(begin, mid, end);

    // Algorytm rwnie dzieli kolekcj w taki sposb,
	// aby wszystkie elementy przed nowym elementem "mid"
	// byy mniejsze lub rwne elementom znajdujcym si za nim.

    // Oznacza to, e elementy przed "mid" s elementami, ktre byyby przed nim
	// w cakowicie posortowanym zbiorze. Musimy je tylko posortowa.
    std::sort(begin, mid);
}



int main(int argc, char *argv[])
{
    std::vector<int> xs { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

    std::random_device rd;
    std::mt19937 g(rd());
    std::shuffle(xs.begin(), xs.end(), g);

    std::cout << "Przed sortowaniem: ";
    for (const auto& x: xs) {
        std::cout << x << ' ';
    }
    std::cout << std::endl;

    sort_until(xs.begin(), xs.begin() + 3, xs.end());

    std::cout << "Po sortowaniu: ";
    for (const auto& x: xs) {
        std::cout << x << ' ';
    }
    std::cout << std::endl;
}

