
#include <iostream>
#include <vector>
#include <algorithm>

#include "../../common/person.h"

// Implementuje generyczny obiekt funkcyjny, ktry porwnuje wiek obiektu
// z wczeniej zdefiniowan wartoci cakowit (punkt 3.1.4).
class older_than {
public:
    older_than(int limit)
       : m_limit(limit)
    {
    }

    // Definiujc operator wywoania w postaci szablonu funkcji
    // stworzymy generyczny obiekt funkcyjny, 
    // ktry podczas wywoania wyznacza typy swoich argumentw.
    template <typename T>
    bool operator() (T &&object) const
    {
        return std::forward<T>(object).age() > m_limit;
    }

private:
    int m_limit;
};


int main(int argc, char *argv[])
{
    std::vector<person_t> persons;

    older_than predicate(42);

    std::count_if(persons.cbegin(), persons.cend(), predicate);

    return 0;
}
