
#include <iostream>
#include <numeric>
#include <vector>

#if 0
// Wersja imperatywna
double average_score(const std::vector<int> &scores)
{
    int sum = 0;

    for (int score: scores) {
        sum += score;
    }

    return sum / (double) scores.size();
}
#endif

// Obliczanie wartoci redniej za pomoc std::accumulate.
// Domylnie algorytm accumulate wykorzystuje dodawanie
// jako operacj skadania dla kolekcji
// (patrz punkt 2.2.1)
double average_score(const std::vector<int> &scores)
{
    return std::accumulate(
               scores.cbegin(), scores.cend(),
               0
            ) / (double) scores.size();
}

// Moemy udostpni dziaanie zdefniowane przez uytkownika.
// W tym przypadku bdziemy mnoy oceny.
double scores_product(const std::vector<int> &scores)
{
    return std::accumulate(
               scores.cbegin(), scores.cend(),
               1,
               std::multiplies<int>()
            );
}

int main(int argc, char *argv[])
{
    std::cout << average_score({1, 2, 3, 4}) << '\n';
    std::cout << scores_product({1, 2, 3, 4}) << '\n';
}

