#ifndef UTILS_H
#define UTILS_H


// Klasa uytkowa dla debugowania typw dedukowanych
template <typename T>
class error;


// Uytkowa metafunkcja wykrywajca poprawno typu
template <typename ...T>
using void_t = void;

// Jeli uywasz starszego kompilatora,
// zamie powysz definicj na nastpujc:
//     template<typename... Ts> struct make_void { typedef void type;};
//     template<typename... Ts> using void_t = typename make_void<Ts...>::type;


// Metafunkcja, ktra zwraca typ elementu w kolekcji iterowalnej
template <typename T>
using contained_type =
    std::remove_cv_t<
        std::remove_reference_t<
            decltype(*std::begin(std::declval<T>()))
        >
    >;


// Metafunkcja, ktra zwraca typ z usunit referencj
template <typename T>
struct remove_reference {
    using type = T;
};

template <typename T>
struct remove_reference<T&> {
    using type = T;
};

template <typename T>
struct remove_reference<T&&> {
    using type = T;
};

template <typename T>
using remove_reference_t = typename remove_reference<T>::type;


// Metafunkcja, ktra wykrywa, czy typ zawiera zagniedon definicj "value_type"
template < typename C
         , typename = void_t<>
         >
struct has_value_type : std::false_type {};

template<typename C>
struct has_value_type<C, void_t<typename C::value_type>> : std::true_type {};


template < typename C
         , typename = void_t<>
         >
struct is_iterable : std::false_type {};

template <typename C>
struct is_iterable
    <C, void_t < decltype(*std::begin(std::declval<C>()))
               , decltype(std::end(std::declval<C>()))
               >>
    : std::true_type {};


// Metafunkcja, ktra zawsze zwraca false.
// Warto jej uywa z narzdziem static_assert
// i instrukcj if zawierajc specyfikator constexpt.
template <typename...>
struct false_: std::false_type {};





#endif /* !UTILS_H */
