
#include <string>
#include <iostream>
#include <vector>
#include <algorithm>
#include <functional>
#include <fstream>

#include "../../common/person.h"

void print_person(const person_t &person,
                  std::ostream &out,
                  person_t::output_format_t format)
{
    if (format == person_t::name_only) {
        out << person.name() << '\n';

    } else if (format == person_t::full_name) {
        out << person.name() << ' '
            << person.surname() << '\n';

    }
}

int main(int argc, char *argv[])
{
    using namespace std::placeholders;

    std::vector<person_t> people {
        { "Dawid"  , person_t::male   },
        { "Janina" , person_t::female },
        { "Marta"  , person_t::female },
        { "Piotr"  , person_t::male   },
        { "Renata" , person_t::female },
        { "Tomasz" , person_t::male   }
    };

    std::ofstream file("test");

    // Przekazywanie do std::bind funkcji nieczonkowskiej w postaci obiektu funkcyjnego 
    std::for_each(people.cbegin(), people.cend(),
            std::bind(print_person,
                      _1,
                      std::ref(std::cout),
                      person_t::name_only
                ));

    std::for_each(people.cbegin(), people.cend(),
            std::bind(print_person,
                      _1,
                      std::ref(file),
                      person_t::full_name
                ));

    // Przekazywanie do std::bind wskanika do funkcji skadowej 
    std::for_each(people.cbegin(), people.cend(),
            std::bind(&person_t::print,
                      _1,
                      std::ref(std::cout),
                      person_t::name_only
                ));

    // Przekazywanie wyraenia lambda zamiast uycia std::bind
    std::for_each(people.cbegin(), people.cend(),
            [] (const person_t &person) {
                print_person(person,
                             std::cout,
                             person_t::name_only);
            });

    std::for_each(people.cbegin(), people.cend(),
            [&file] (const person_t &person) {
                print_person(person,
                             file,
                             person_t::full_name);
            });

    return 0;
}
