// vim: zdefiniuj parametr set undofile:
// Program: 06-generalized-memoization

#include <iostream>
#include <map>
#include <tuple>
#include <unordered_map>

// patrz podrozdział 6.3 i listing 6.7
template <typename Result, typename... Args>
auto make_memoized(Result (*f)(Args...))
{
    // Tworzy pamięć podręczną, która odwzorowuje krotki argumentów na obliczone wyniki.
	// Jeśli chcesz użyć tego kodu w środowisku wielowątkowym, musisz synchronizować
	// wprowadzane zmiany za pomocą muteksu, tak jak przedstawiono na listingu 6.1.
    std::map<std::tuple<Args...>, Result> cache;

    return [f, cache](Args... args) mutable -> Result
    {
        // Wyrażenie lambda, które pobiera argumenty i sprawdza, czy wynik
        // został już zbuforowany
        const auto args_tuple =
            std::make_tuple(args...);
        const auto cached = cache.find(args_tuple);

        if (cached == cache.end()) {
            // Gdy wynik nie znajduje się w pamięci podręcznej, wywołuje funkcję
            // i zapisuje go do tej pamięci
            auto result = f(args...);
            cache[args_tuple] = result;
            return result;

        } else {
            // Gdy wynik znaleziono w pamięci podręcznej, zwraca go do kodu wywołującego
            return cached->second;
        }
    };
}


unsigned int fib(unsigned int n)
{
    std::cout << "Obliczanie " << n << "!\n";
    return n == 0 ? 0
         : n == 1 ? 1
         : fib(n - 1) + fib(n - 2);
}


int main(int argc, char* argv[])
{
    auto fibmemo = make_memoized(fib);

    std::cout << "15! = " << fibmemo(15) << std::endl;      // <1>
    std::cout << "15! = " << fibmemo(15) << std::endl;      // <2>

    return 0;
}


