
#include <iostream>
#include <vector>
#include <algorithm>

#include "../../common/person.h"

// Patrz punkt 3.2.2
class company_t {
public:
    std::string team_name_for(const person_t &) const;

    int count_team_members(const std::string &team_name) const;

private:
    std::vector<person_t> m_employees;

};

std::string company_t::team_name_for(const person_t &person) const
{
    // Tylko do testw -
    // odpowiednia implementacja moe by dobrym wiczeniem.
    return "Zesp1";
}

int company_t::count_team_members(const std::string &team_name) const
{
    // Zliczanie czonkw zespou przy uyciu wyraenia lambda.
    //
    // Wyraenie lambda musi przechwyci wskanik "this", poniewa musi mie dostp
    // do zmiennej skadowej "m_employees". Wyraenie lambda przechwytuje
    // zmienn "team_name" w celu sprawdzenia, czy pracownik naley do danego zespou.
    return std::count_if(
            m_employees.cbegin(), m_employees.cend(),
            [this, &team_name]
                (const person_t &employee)
            {
                return team_name_for(employee) == team_name;
            }
        );
}

int main(int argc, char *argv[])
{
    // Jako wiczenie stwrz instancj obiektu company_t,
    // a nastpnie przetestuj funkcj skadow count_team_members member.
}

