(ns clojurebreaker.models.game
  (:require [clojure.data :as data]))

(defn create []
  (vec (repeatedly 4 (fn [] (rand-nth ["r" "g" "b" "y"])))))

(defn exact-matches
  "Przyjmuje dwie kolekcje i zwraca liczb pozycji, na ktrych
   kolekcje obejmuj identyczne elementy."
  [c1 c2]
  (let [[_ _ matches] (data/diff c1 c2)]
    (count (remove nil? matches))))

(defn unordered-matches
  "Przyjmuje dwie kolekcje i zwraca odwzorowanie, w ktrym kady klucz to
   element wystpujcy w obu kolekcjach, a kada warto to liczba wystpie
   elementu w kolekcji, gdzie dany element wystpuje mniejsz liczb razy."
  [c1 c2]
  (let [f1 (select-keys (frequencies c1) c2)
        f2 (select-keys (frequencies c2) c1)]
    (merge-with min f1 f2)))

(defn score
  [c1 c2]
  (let [exact (exact-matches c1 c2)
        unordered (apply + (vals (unordered-matches c1 c2)))]
    {:exact exact :unordered (- unordered exact)}))