(ns examples.test.macros
  (:use clojure.test examples.macros))

; Funkcja unless-1 wartociuje argumenty przed testem
(deftest test-unless-1
  (is (thrown? Exception (unless-1 false (throw (Exception.)))))
  (is (thrown? Exception (unless-1 true (throw (Exception.))))))

; Funkcja unless-2 wartociuje argumenty przed testem
(deftest test-unless-2
  (are [x y] (= x y)
   (with-out-str (unless-2 false :foo)) "Przed testem...\n"
   (with-out-str (unless-2 true :foo)) "Przed testem...\n"))

; unless-3 to makro i dziaa w poprawny sposb
(deftest test-unless
  (is (thrown? Exception (unless false (throw (Exception.)))))
  (unless true (throw (Exception.))))

; bad-unless powoduje przechwytywanie symbolu
(deftest test-expansions
  (are [x y] (= x y)
   (macroexpand-1 '(examples.macros/unless false :foo)) '(if false nil :foo)
   (macroexpand-1 '(examples.macros/bad-unless false :foo)) '(if expr nil :foo)))

(deftest test-bench-2
  (are [x y] (= x y)
   (:result (examples.macros/bench (+ 1 2)))
   3))

(deftest test-bench-fn
  (are [x y] (= x y)
   (:result (examples.macros/bench-fn (fn [] (+ 2 2))))
   4))
				      
	    

  
