(ns examples.test.introduction
  (:use clojure.test
        examples.introduction))

(deftest test-blank?
  (is (blank? nil))
  (is (blank? ""))
  (is (blank? " "))
  (is (false? (blank? "boo"))))

(deftest test-accounts
  (dosync (commute accounts conj (struct account "CLSS" 0)))
  (is (= #{{:id "CLSS" :balance 0}} @accounts)))

(deftest test-fibs
  (is (= [0 1 1 2 3 5 8 13 21 34] (take 10 fibs))))

(deftest test-hello-docstring
  (is (= (with-out-str (hello-docstring "Aaron")) "Witaj, Aaron\n")))
  
; W rozdziale znajduje si kilka funkcji hello. Ostatnia powinna mie ponisz dokumentacj
(deftest test-hello-has-a-docstring
  (is (= "Wywietla powitanie na wyjciu. Pozdrawia, uywajc nazwy uytkownika.\n Uwzgldnia wczeniejsze wizyty."
         (:doc (meta #'hello)))))
