(ns examples.test.exploring
  (:use clojure.test examples.exploring))

(defn call-date [& args]
  (with-out-str (apply date args)))

(deftest test-date
  (is (= "Na randce: a i b. Liczba opiekunw: 2.\n"
         (call-date "a" "b" "c" "d"))))

(deftest test-is-small-with-if?
  (is (= "tak" (is-small-with-if? 99)))
  (is (= nil (is-small-with-if? 100)))
  (is (= nil (is-small-with-if? 101))))

(deftest test-is-small-with-else?
  (is (= "tak" (is-small-with-else? 99)))
  (is (= "nie" (is-small-with-else? 100)))
  (is (= "nie" (is-small-with-else? 101))))

(deftest test-is-small-with-do?
  (is (=
       "Wystpia dua liczba 100\nWystpia dua liczba 101\n"
       (with-out-str
         (is (= "tak" (is-small-with-do? 99)))
         (is (= "nie" (is-small-with-do? 100)))
         (is (= "nie" (is-small-with-do? 101)))))))

(deftest test-demo-loop
  (is (= [5 4 3 2 1] (demo-loop))))

(deftest test-countdown
  (is (= [4 3 2 1] (countdown [] 4))))

(deftest test-index-of-any
  (is (= nil (index-of-any #{\d \e \f \g} "abc")))
  (is (= 1 (index-of-any #{\d \e \f \g} "add"))))

(deftest test-greeting
  (is (= "Witaj, foo" (simple-greeting "foo"))))

(deftest test-greeting-with-default
  (is (= "Witaj, world" (greeting-with-default)))
  (is (= "Witaj, foo" (greeting-with-default "foo"))))

(deftest test-indexable-word
  (is (indexable-word? "super"))
  (is (false? (indexable-word? "at"))))

(deftest test-indexable-words
  (is (= ["this" "working"] (indexable-words "this is working"))))

(deftest test-make-greeter
  (let [g (make-greeter "jak leci")]
    (is (= "jak leci, stary" (g "stary")))))

(deftest test-square-corners
  (is (= [[0 0] [2 0] [2 2] [0 2]]
           (square-corners 0 0 2))))

(deftest test-busted
  (is (thrown? AssertionError (test #'busted))))

(deftest test-greet-author-1
  (is (= "Witaj, Jan\n" (with-out-str (greet-author-1 {:first-name "Jan"})))))

(deftest test-greet-author-2
  (is (= "Witaj, Adam\n" (with-out-str (greet-author-2 {:first-name "Adam"})))))

(deftest test-ellipsize
  (is (= "This had better ..."
         (ellipsize "This had better work!")))
  (is (= "This had better ..."
         (ellipsize "This     had     better    work     too!"))))

; START: thrown
(deftest test-divide-by-zero
  (is (thrown? ArithmeticException (/ 5 0))))
; END: thrown
