; Przykad inspirowany tekstem http://gigamonkeys.com/book/beyond-exception-handling-conditions-and-restarts.html
(ns examples.error-kit
 (:use [clojure.contrib.error-kit]))

(deferror malformed-log-entry [] [msg]
  {:msg msg
   :unhandled (throw-msg IllegalArgumentException)})

; Fikcyjny format komunikatw z ostrzeeniami:
; 2008-10-05 12:14:00 WARN Komunikat z ostrzeeniem...
(defn parse-log-entry [entry]
  (or
    (next (re-matches #"(\d+-\d+-\d+) (\d+:\d+:\d+) (\w+) (.*)" entry))
    (raise malformed-log-entry entry)))

(def bad-log 
 ["2008-10-05 12:14:00 WARN Komunikat z ostrzeeniem..."
  "<<To nie jest komunikat z dziennika>>"
  "2008-10-05 12:14:00 INFO Koniec dziennika..."])

(def good-log 
 ["2008-10-05 12:14:00 WARN Komunikat z ostrzeeniem..."
  "2008-10-05 12:14:00 INFO Koniec dziennika..."])

; Przykad 1. Kontynuowanie oblicze dla zastpczej wartoci
(defn parse-or-nil [logseq]
  (with-handler 
    (vec (map parse-log-entry logseq))
    (handle malformed-log-entry [msg]
      (continue-with nil))))
	    
; Przykad 2. Kontynuowanie oblicze dla zastpczej wartoci z rejestrowaniem informacji
(defn parse-or-warn [logseq]
  (with-handler 
    (vec (map parse-log-entry logseq))
    (handle malformed-log-entry [msg]
      (continue-with (println "****ostrzeenie****: nieprawidowy wpis: " msg)))))

; Przykad 3. W jednostce wywoujcej mona wybra jedn ze strategii kontynuacji.
(defn parse-or-continue [logseq]
  (let [parse-log-entry 
	(fn [entry]
	  (with-handler (parse-log-entry entry)
			(bind-continue skip [msg] nil)
			(bind-continue log [msg] (println "****ostrzeenie****: nieprawidowy wpis: " msg))))]
    (vec (map parse-log-entry logseq))))



   


 			    