/***
 * Z ksiki "Programowanie w Clojure, wydanie drugie",
 * opublikowanej przez The Pragmatic Bookshelf.
 * Kod chroniony prawem autorskim. Kodu nie mona wykorzystywa w materiaach szkoleniowych,
 * kursach, ksikach, artykuach i podobnych materiaach. W razie wtpliwoci naley skontaktowa
 * si z wydawnictwem.
 * Wydawnictwo nie ponosi adnej odpowiedzialnoci za wykorzystanie kodu. 
 * Informacje o ksice znajdziesz na stronie http://www.pragmaticprogrammer.com/titles/shcloj2.
***/
/* Unobtrustive Code Highlighter, Autork: Dan Webb 11/2005
   Wersja: 0.4
	
	Stosowanie:
		Dodaj znacznik script z tym skryptem i style potrzebne
		na danej stronie, dodaj odpowiednie nazwy klas do elementw CODE, 
		zdefiniuj style CSS dla elementw. Gotowe! 
	
	Dziaa na:
		IE 5.5+ PC
		Firefox/Mozilla PC/Mac
		Opera 7.23 + PC
		Safari 2
		
	Nie dziaa (bez zgaszania przy tym bdw):
		IE5.0 PC
	
	Uwaga: w IE5.0 skrypt nie dziaa z uwagi na dopasowywanie z uwzgldnieniem dalszych wzorcw (lookahead) 
	w niektrych obiektach styleSets. Aby unikn bdw skryptu w starszych przegldarkach,
	w obiektach styleSets naley uywa wyrae z lookahead w formie acuchw znakw.
	
	Skrypt jest inspirowany narzdziem star-light Deana Edwardsa
	http://dean.edwards.name/star-light/.  
*/

// Obsuga wywoania zwrotnego replace na potrzeby przegldarki Safari.
if ("a".replace(/a/, function() {return "b"}) != "b") (function(){
  var default_replace = String.prototype.replace;
  String.prototype.replace = function(search,replace){
	// replace to nie funkcja
	if(typeof replace != "function"){
		return default_replace.apply(this,arguments)
	}
	var str = "" + this;
	var callback = replace;
	// acuch znakw search to nie RegExp
	if(!(search instanceof RegExp)){
		var idx = str.indexOf(search);
		return (
			idx == -1 ? str :
			default_replace.apply(str,[search,callback(search, idx, str)])
		)
	}
	var reg = search;
	var result = [];
	var lastidx = reg.lastIndex;
	var re;
	while((re = reg.exec(str)) != null){
		var idx  = re.index;
		var args = re.concat(idx, str);
		result.push(
			str.slice(lastidx,idx),
			callback.apply(null,args).toString()
		);
		if(!reg.global){
			lastidx += RegExp.lastMatch.length;
			break
		}else{
			lastidx = reg.lastIndex;
		}
	}
	result.push(str.slice(lastidx));
	return result.join("")
  }
})();

var CodeHighlighter = { styleSets : new Array };

CodeHighlighter.addStyle = function(name, rules) {
	// Test z instrukcj push uniemoliwia starszym przegldarkom dodawanie obiektw styleSets
	if ([].push) this.styleSets.push({
		name : name, 
		rules : rules,
		ignoreCase : arguments[2] || false
	})
	
	function setEvent() {
		// Mechanizm kolorowania skadni ma dziaa przy wczytywaniu
		if (typeof Event != 'undefined' && typeof Event.onReady == 'function') 
		  return Event.onReady(CodeHighlighter.init.bind(CodeHighlighter));
		
		var old = window.onload;
		
		if (typeof window.onload != 'function') {
			window.onload = function() { CodeHighlighter.init() };
		} else {
			window.onload = function() {
				old();
				CodeHighlighter.init();
			}
		}
	}
	
	// Zdarzenie jest ustawiane tylko przy dodawaniu pierwszego stylu
	if (this.styleSets.length==1) setEvent();
}

CodeHighlighter.init = function() {
	if (!document.getElementsByTagName) return; 
	if ("a".replace(/a/, function() {return "b"}) != "b") return; 
	// Pomijanie wersji Safari nieobsugujcych funkcji replace
	// Pomijanie starszych przegldarek
	
	var codeEls = document.getElementsByTagName("CODE");
	// Pobieranie tablicy wszystkie elementw kodu
	codeEls.filter = function(f) {
		var a =  new Array;
		for (var i = 0; i < this.length; i++) if (f(this[i])) a[a.length] = this[i];
		return a;
	} 
	
	var rules = new Array;
	rules.toString = function() {
		// Zcza wyraenia regularne w jedno due rwnolegle przetwarzane wyraenie
		var exps = new Array;
		for (var i = 0; i < this.length; i++) exps.push(this[i].exp);
		return exps.join("|");
	}
	
	function addRule(className, rule) {
		// Dodawanie reguy zastpowania
		var exp = (typeof rule.exp != "string")?String(rule.exp).substr(1, String(rule.exp).length-2):rule.exp;
		// Przeksztaca wyraenia regularne na acuchy znakw i usuwa ukoniki
		rules.push({
			className : className,
			exp : "(" + exp + ")",
			length : (exp.match(/(^|[^\\])\([^?]/g) || "").length + 1, // Liczba podwyrae w regule
			replacement : rule.replacement || null 
		});
	}
	
	function parse(text, ignoreCase) {
		// Przetwarzanie gwnego tekstu i zastpowanie elementw
		return text.replace(new RegExp(rules, (ignoreCase)?"gi":"g"), function() {
			var i = 0, j = 1, rule;
			while (rule = rules[i++]) {
				if (arguments[j]) {
					// Jeli nie okrelono niestandardowego zastpnika, naley przeprowadzi proste zastpowanie
					if (!rule.replacement) return "<span class=\"" + rule.className + "\">" + arguments[0] + "</span>";
					else {
						// Cig $0 naley zastpi przez className, a nastpnie przeprowadzi standardowe zastpowanie
						var str = rule.replacement.replace("$0", rule.className);
						for (var k = 1; k <= rule.length - 1; k++) str = str.replace("$" + k, arguments[j + k]);
						return str;
					}
				} else j+= rule.length;
			}
		});
	}
	
	function highlightCode(styleSet) {
		// Oprnianie tablicy z reguami
		var parsed, clsRx = new RegExp("(\\s|^)" + styleSet.name + "(\\s|$)");
		rules.length = 0;
		
		// Pobieranie elementw, dla ktrych okrelany jest styl. 
		// W tym celu naley odfiltrowa wszystkie elementy kodu bez prawidowej nazwy klasy (className)	
		var stylableEls = codeEls.filter(function(item) { return clsRx.test(item.className) });
		
		// Dodawanie do parsera regu nadawania stylu
		for (var className in styleSet.rules) addRule(className, styleSet.rules[className]);
		
			
		// Zastpowanie wszystkich elementw
		for (var i = 0; i < stylableEls.length; i++) {
			// Sztuczka rozwizujca problemy z odstpami w elementach <pre> w przegldarce IE
			if (/MSIE/.test(navigator.appVersion) && stylableEls[i].parentNode.nodeName == 'PRE') {
				stylableEls[i] = stylableEls[i].parentNode;
				
				parsed = stylableEls[i].innerHTML.replace(/(<code[^>]*>)([^<]*)<\/code>/i, function() {
					return arguments[1] + parse(arguments[2], styleSet.ignoreCase) + "</code>"
				});
				parsed = parsed.replace(/\n( *)/g, function() { 
					var spaces = "";
					for (var i = 0; i < arguments[1].length; i++) spaces+= "&nbsp;";
					return "\n" + spaces;  
				});
				parsed = parsed.replace(/\t/g, "&nbsp;&nbsp;&nbsp;&nbsp;");
				parsed = parsed.replace(/\n(<\/\w+>)?/g, "<br />$1").replace(/<br \/>[\n\r\s]*<br \/>/g, "<p><br></p>");
				
			} else parsed = parse(stylableEls[i].innerHTML, styleSet.ignoreCase);
			
			stylableEls[i].innerHTML = parsed;
		}
	}
		
	// Uruchamianie mechanizmu kolorowania skadni dla wszystkich obiektw styleSets
	for (var i=0; i < this.styleSets.length; i++) {
		highlightCode(this.styleSets[i]);  
	}
}