// Aby użyć tego pliku testującego, będiesz musiał zostawić obiekty widoku, modelu
// i kontrolera na miejscach, lecz zakomentować cały kod testujących za wyjątkiem
// tych jego fragmentów, których chcesz używać. Pamiętaj, że możesz używać 
// komentarzy blokowych:

/* 
   kod w komentarzu blokowym
*/
// lub zakomentować wybrane wiersze, tak jak zrobiliśmy tutaj.


// testing the view
const view = {
	displayMessage(msg) {
		let messageArea = document.getElementById("messageArea");
		messageArea.innerHTML = msg;
	},

	displayHit(location) {
		let cell = document.getElementById(location);
		cell.setAttribute("class", "hit");
	},

	displayMiss(location) {
		let cell = document.getElementById(location);
		cell.setAttribute("class", "miss");
	}

}; 

view.displayMiss("00");
view.displayHit("34");
view.displayMiss("55");
view.displayHit("12");
view.displayMiss("25");
view.displayHit("26");

view.displayMessage("Raz, dwa, trzy, czy to jest włączone?");

// Testowanie modelu

const model = {
	boardSize: 7,
	numShips: 3,
	shipLength: 3,
	shipsSunk: 0,
	
	ships: [
		{ locations: ["06", "16", "26"], hits: ["", "", ""] },
		{ locations: ["24", "34", "44"], hits: ["", "", ""] },
		{ locations: ["10", "11", "12"], hits: ["", "", ""] }
	],

	fire(guess) {
		for (let i = 0; i < this.numShips; i++) {
			let ship = this.ships[i];
			let index = ship.locations.indexOf(guess);

			if (index >= 0) {
				ship.hits[index] = "hit";
				view.displayHit(guess);
				view.displayMessage("TRAFIONY!");

				if (this.isSunk(ship)) {
					view.displayMessage("Zatopiłeś mój okręt!");
					this.shipsSunk++;
				}
				return true;
			}
		}
		view.displayMiss(guess);
		view.displayMessage("Spudłowałeś.");
		return false;
	},

	isSunk(ship) {
		return (!ship.hits.includes[""]);
	},

	generateShipLocations() {
		let locations;
		for (let i = 0; i < this.numShips; i++) {
			do {
				locations = this.generateShip();
			} while (this.collision(locations));
			this.ships[i].locations = locations;
		}
		console.log("Tablica okrętów: ");
		console.log(this.ships);
	},

	generateShip() {
		let direction = Math.floor(Math.random() * 2);
		let row;
		let col;

		if (direction === 1) { // W poziomie.
			row = Math.floor(Math.random() * this.boardSize);
			col = Math.floor(Math.random() * (this.boardSize - this.shipLength + 1));
		} else { // W pionie.
			row = Math.floor(Math.random() * (this.boardSize - this.shipLength + 1));
			col = Math.floor(Math.random() * this.boardSize);
		}

		let newShipLocations = [];
		for (let i = 0; i < this.shipLength; i++) {
			if (direction === 1) {
				newShipLocations.push(`${row} ${(col + i)}`);
			} else {
				newShipLocations.push(`${(row + i)} ${col}`);
			}
		}
		return newShipLocations;
	},

	collision(locations) {
		for (let i = 0; i < this.numShips; i++) {
			let ship = this.ships[i];
			for (let j = 0; j < locations.length; j++) {
				if (ship.locations.includes(locations[j])) {
					return true;
				}
			}
		}
		return false;
	}
	
}; 

/*
model.fire("53"); // pudło

model.fire("06"); // trafiony
model.fire("16"); // trafiony
model.fire("26"); // trafiony

model.fire("34"); // trafiony
model.fire("24"); // trafiony
model.fire("44"); // trafiony

model.fire("12"); // trafiony
model.fire("11"); // trafiony
model.fire("10"); // trafiony
*/


// Testowanie funkcji parseGuess
function parseGuess(guess) {
	const alphabet = ["A", "B", "C", "D", "E", "F", "G"];

	if (guess === null || guess.length !== 2) {
		alert("Ups, proszę wpisać literę i cyfrę.");
	} else {
		let row = alphabet.indexOf(guess.charAt(0));
		let column = guess.charAt(1);
		
		if (isNaN(column)) {
			alert("Ups, to nie są współrzędne!");
		} else if (row < 0 || row >= model.boardSize ||
		           column < 0 || column >= model.boardSize) {
			alert("Ups, pole poza planszą!");
		} else {
			return row + column;
		}
	}
	return null;
}

/*
console.log("Testowanie funkcji parseGuess");
console.log(parseGuess("A0"));
console.log(parseGuess("B6"));
console.log(parseGuess("G3"));
console.log(parseGuess("H0")); // invalid
console.log(parseGuess("A7")); // invalid
*/

// Testowanie kontrolera

const controller = {
	guesses: 0,

	processGuess(guess) {
		let location = parseGuess(guess);
		if (location) {
			this.guesses++;
			let hit = model.fire(location);
			if (hit && model.shipsSunk === model.numShips) {
				view.displayMessage(`Zatopiłeś wszystkie moje okręty w ${this.guesses} próbach  .`);
			}
		}
	}
}


// Na planszy powinny znajdować się 3 okręty, jedno pudło i komunikat
// "You sank all my battleships in 10 guesses"
/*
controller.processGuess("A0"); // miss

controller.processGuess("A6"); // hit
controller.processGuess("B6"); // hit
controller.processGuess("C6"); // hit

controller.processGuess("C4"); // hit
controller.processGuess("D4"); // hit
controller.processGuess("E4"); // hit

controller.processGuess("B0"); // hit
controller.processGuess("B1"); // hit
controller.processGuess("B2"); // hit
*/

