const model = {
	boardSize: 7,
	numShips: 3,
	shipLength: 3,
	shipsSunk: 0,
	
	ships: [
		{ locations: [0, 0, 0], hits: ["", "", ""] },
		{ locations: [0, 0, 0], hits: ["", "", ""] },
		{ locations: [0, 0, 0], hits: ["", "", ""] }
	],

	// Początkowe położenie okrętów, podane na stałe.
	//*
	ships: [
		{ locations: ["06", "16", "26"], hits: ["", "", ""] },
		{ locations: ["24", "34", "44"], hits: ["", "", ""] },
		{ locations: ["10", "11", "12"], hits: ["", "", ""] }
	],
	//*/

	fire(guess) {
		for (let i = 0; i < this.numShips; i++) {
			let ship = this.ships[i];
			let index = ship.locations.indexOf(guess);

			// To jest usprawnienie! Sprawdzamy, czy okręt nie 
			// został już trafiony, wyświetlamy stosowny komunikat
			// użytkownikowi i kończymy działanie.
			if (ship.hits[index] === "hit") {
				view.displayMessage("Ups, już wcześnej trafiłeś to pole!");
				return true;
			} else if (index >= 0) {
				ship.hits[index] = "hit";
				view.displayHit(guess);
				view.displayMessage("TRAFIONY!");

				if (this.isSunk(ship)) {
					view.displayMessage("Zatopiłeś mój okręt!");
					this.shipsSunk++;
				}
				return true;
			}
		}
		view.displayMiss(guess);
		view.displayMessage("Spudłowałeś.");
		return false;
	},

	isSunk(ship) {
		return (!ship.hits.includes(""));
/*
		for (let i = 0; i < this.shipLength; i++)  {
			if (ship.hits[i] !== "hit") {
				return false;
			}
		}
	    return true;
*/
	},

	generateShipLocations() {
		let locations;
		for (let i = 0; i < this.numShips; i++) {
			do {
				locations = this.generateShip();
			} while (this.collision(locations));
			this.ships[i].locations = locations;
		}
		console.log("Tablica okrętów: ");
		console.log(this.ships);
	},

	generateShip() {
		let direction = Math.floor(Math.random() * 2);
		let row;
		let col;

		if (direction === 1) { // W poziomie.
			row = Math.floor(Math.random() * this.boardSize);
			col = Math.floor(Math.random() * (this.boardSize - this.shipLength + 1));
		} else { // W pionie.
			row = Math.floor(Math.random() * (this.boardSize - this.shipLength + 1));
			col = Math.floor(Math.random() * this.boardSize);
		}

		let newShipLocations = [];
		for (let i = 0; i < this.shipLength; i++) {
			if (direction === 1) {
				newShipLocations.push(`${row}${(col + i)}`);
			} else {
				newShipLocations.push(`${(row + i)}${col}`);
			}
		}
		return newShipLocations;
	},

	collision(locations) {
		for (let i = 0; i < this.numShips; i++) {
			let ship = this.ships[i];
			for (let j = 0; j < locations.length; j++) {
				if (ship.locations.includes(locations[j])) {
					return true;
				}
			}
		}
		return false;
	}
	
}; 


const view = {
	displayMessage(msg) {
		let messageArea = document.getElementById("messageArea");
		messageArea.innerHTML = msg;
	},

	displayHit(location) {
		let cell = document.getElementById(location);
		cell.setAttribute("class", "hit");
	},

	displayMiss(location) {
		let cell = document.getElementById(location);
		cell.setAttribute("class", "miss");
	}

}; 

const controller = {
	guesses: 0,

	parseGuess(guess) {
		const alphabet = ["A", "B", "C", "D", "E", "F", "G"];

		if (guess === null || guess.length !== 2) {
			alert("Ups, proszę wpisać literę i cyfrę, określające pole planszy.");
		} else {
			let firstChar = guess.charAt(0);
			let row = alphabet.indexOf(firstChar);
			let column = guess.charAt(1);
		
			if (isNaN(column)) {
				alert("Ups, ta kolumna jest poza planszą!");
			} else if (row < 0 || row >= model.boardSize ||
		           	column < 0 || column >= model.boardSize) {
				alert("Ups, to pole leży poza planszą!");
			} else {
				return row + column;
			}
		}
		return null;
	},

	processGuess(guess) {
		let location = this.parseGuess(guess);
		if (location) {
			this.guesses++;
			let hit = model.fire(location);
			if (hit && model.shipsSunk === model.numShips) {
				view.displayMessage(`Zatopiłeś wszystkie moje okręty w ${this.guesses} próbach.`);
			}
		}
	}
};


// Obsługa zdarzeń

function handleFireButton() {
	let guessInput = document.getElementById("guessInput");
	let guess = guessInput.value.toUpperCase();

	controller.processGuess(guess);

	guessInput.value = "";
}

function handleKeyPress(e) {
	let fireButton = document.getElementById("fireButton");

	// W przeglądarce IE9 i starszych, obiekt event nie był prawidłowo przekazywany
	// do procedur obsługi zdarzeń, więc trzeba używać obiektu window.event.
	e = e || window.event;

	if (e.keyCode === 13) {
		fireButton.click();
		return false;
	}
}


// init - wywoływana kiedy zostanie zakończone wczytywanie strony.

window.onload = init;

function init() {
	// Procedura obsługi zdarzeń onclick przycisku Ognia!
	let fireButton = document.getElementById("fireButton");
	fireButton.onclick = handleFireButton;

	// Obsługa naciśnięcia klawisza "return"
	let guessInput = document.getElementById("guessInput");
	guessInput.onkeydown = handleKeyPress;

	// Umieszcza okręt na planszy
	model.generateShipLocations();
}
