// Rysunek 28.1. MatcherMethods.java
// Nowe metody klasy Matcher w Javie 9
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MatcherMethods {
   public static void main(String[] args) {
      String sentence = "to pan a to plan z palmami panamskimi"; 

      System.out.printf("zdanie: %s%n", sentence);

      // Wykorzystywany przez appendReplacement i appendTail z Matcher
      Pattern pattern = Pattern.compile("an"); // Wyrażenie regularne do dopasowania

      // Dopasowanie wyrażenia regularnego do tekstu
      // i zastąpienie każdego dopasowania dużymi literami
      Matcher matcher = pattern.matcher(sentence);

      // Służy do przebudowania tekstu.
      StringBuilder builder = new StringBuilder(); 

      // Dołącza tekst do builder i konwertuje każde dopasowanie na duże litery
      while (matcher.find()) {
         matcher.appendReplacement(
            builder, matcher.group().toUpperCase());
      } 

      // Dodanie pozostałej części oryginalnego tekstu do builder
      matcher.appendTail(builder);
      System.out.printf(
         "%nPo appendReplacement i appendTail: %s%n", builder);

      // Użycie metody replaceFirst z Matcher
      matcher.reset(); // Przywrócenie matcher do stanu początkowego
      System.out.printf("%nPrzed replaceFirst: %s%n", sentence);
      String result = matcher.replaceFirst(m -> m.group().toUpperCase());
      System.out.printf("Po replaceFirst: %s%n", result);

      // Użycie metody replaceAll z Matcher
      matcher.reset(); // Przywrócenie matcher do stanu początkowego
      System.out.printf("%nPrzed replaceAll: %s%n", sentence);
      result = matcher.replaceAll(m -> m.group().toUpperCase());
      System.out.printf("Po replaceAll: %s%n", result);

      // Użycie metody results do pobrania Stream<MatchResult>
      System.out.printf("%nUżycie metody results z Matcher:%n"); 
      pattern = Pattern.compile("\\w+"); // Wyrażenie regularne do dopasowania
      matcher = pattern.matcher(sentence);
      System.out.printf("Liczba słów: %d%n", 
         matcher.results().count());

      matcher.reset(); // Przywrócenie matcher do stanu początkowego
      System.out.printf("Średnia liczba znaków w słowie: %f%n", 
         matcher.results()
                .mapToInt(m -> m.group().length())
                .average().orElse(0));
   } 
}


/*
 **************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 **************************************************************************
*/

