// Rysunek 27.11. Time1.java
// Klasa Time1, która zostanie umieszczona w module
package com.deitel.timelibrary;

public class Time1 {
   private int hour; // 0 - 23  
   private int minute; // 0 - 59
   private int second; // 0 - 59

   // Ustaw nowy czas, używając czasu uniwersalnego
   // Zgłoś wyjątek, jeśli godzina, minuta lub sekunda znajduje się poza zakresem
   public void setTime(int hour, int minute, int second) {
      // Sprawdź poprawność parametrów hour, minute i second
      if (hour < 0 || hour >= 24 || minute < 0 || minute >= 60 || 
         second < 0 || second >= 60) {
         throw new IllegalArgumentException(               
            "Wartość parametru hour, minute lub (i) second poza zakresem");
      }

      this.hour = hour;
      this.minute = minute;
      this.second = second;
   } 

   // Zamień na tekst w formacie uniwersalnym (HH:MM:SS)
   public String toUniversalString() {
      return String.format("%02d:%02d:%02d", hour, minute, second);
   } 

   // Zamień na tekst w formacie 12-godzinnym (H:MM:SS AM lub PM)
   public String toString() {
      return String.format("%d:%02d:%02d %s",         
         ((hour == 0 || hour == 12) ? 12 : hour % 12),
         minute, second, (hour < 12 ? "AM" : "PM"));  
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/