// Rysunek 22.6. PolyShapesController.java
// Rysowanie obiektów Polyline, Polygon i Path
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.ArcTo;    
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.MoveTo;   
import javafx.scene.shape.Path;     
import javafx.scene.shape.Polygon;  
import javafx.scene.shape.Polyline; 

public class PolyShapesController {
   // Typ enum reprezentujący rodzaje kształtów
   private enum ShapeType {POLYLINE, POLYGON, PATH};
   
   // Zmienne instancji związane z komponentami GUI
   @FXML private RadioButton polylineRadioButton;
   @FXML private RadioButton polygonRadioButton;
   @FXML private RadioButton pathRadioButton;
   @FXML private ToggleGroup toggleGroup;
   @FXML private Polyline polyline;
   @FXML private Polygon polygon;  
   @FXML private Path path;        

   // Zmienne instancji dotyczące zarządzania stanem
   private ShapeType shapeType = ShapeType.POLYLINE; 
   private boolean sweepFlag = true; // Używane z łukami w Path
   
   // Ustawia dane użytkownika dla obiektów RadioButton i wyświetla obiekt wielolinii
   public void initialize() {
      // Danymmi użytkownika w kontroce może być dowolny obiekt
      polylineRadioButton.setUserData(ShapeType.POLYLINE);
      polygonRadioButton.setUserData(ShapeType.POLYGON);
      pathRadioButton.setUserData(ShapeType.PATH);
      
      displayShape(); // Ustaw widoczność wielolinii w trakcie uruchamiania aplikacji
   }
   
   // Obsługuje zdarzenie onMouseClicked w obszarze rysowania
   @FXML
   private void drawingAreaMouseClicked(MouseEvent e) {
      polyline.getPoints().addAll(e.getX(), e.getY());
      polygon.getPoints().addAll(e.getX(), e.getY()); 
    
      // Jeśli ścieżka jest pusta, przejdź do pierwszej pozycji kliknięcia i domknij ścieżkę
      if (path.getElements().isEmpty()) {
         path.getElements().add(new MoveTo(e.getX(), e.getY()));
         path.getElements().add(new ClosePath());               
      }
      else { // Wstaw nowy segment ścieżki przed elementem ClosePath
         // Utwórz segment łuku i wstaw go w ścieżce
         ArcTo arcTo = new ArcTo();    
         arcTo.setX(e.getX());         
         arcTo.setY(e.getY());         
         arcTo.setRadiusX(100.0);      
         arcTo.setRadiusY(100.0);      
         arcTo.setSweepFlag(sweepFlag);
         sweepFlag = !sweepFlag;
         path.getElements().add(path.getElements().size() - 1, arcTo);
      }
   }
   
   // Obsługuje akcje kliknięcia przycisków opcji
   @FXML
   private void shapeRadioButtonSelected(ActionEvent e) {
      // Dane użytkownika w przyciskach to stałe ShapeType
      shapeType =                                                  
         (ShapeType) toggleGroup.getSelectedToggle().getUserData();
      displayShape(); // Wyświetl aktualnie wybrany kształt
   } 

   // Wyświetla aktualnie wybrany kształt
   private void displayShape() {
      polyline.setVisible(shapeType == ShapeType.POLYLINE);
      polygon.setVisible(shapeType == ShapeType.POLYGON);
      path.setVisible(shapeType == ShapeType.PATH);         
   } 
   
   // Czyści każdy kształt
   @FXML
   private void clearButtonPressed(ActionEvent event) {
      polyline.getPoints().clear();
      polygon.getPoints().clear(); 
      path.getElements().clear();  
   }
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
