// Rysunek 20.8. StackTest.java
// Program testujący uogólnioną klasę Stack
import java.util.NoSuchElementException;

public class StackTest {
   public static void main(String[] args) {
      double[] doubleElements = {1.1, 2.2, 3.3, 4.4, 5.5};
      int[] integerElements = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
      
      // Utworzenie Stack<Double> i Stack<Integer>
      Stack<Double> doubleStack = new Stack<>(5);   
      Stack<Integer> integerStack = new Stack<>();  

      // Umieszczenie elementów doubleElements w doubleStack
      testPushDouble(doubleStack, doubleElements); 
      testPopDouble(doubleStack); // Zdjęcie z doubleStack

      // Umieszczenie elementów integerElements w integerStack
      testPushInteger(integerStack, integerElements); 
      testPopInteger(integerStack); // Zdjęcie z integerStack
   } 

   // Testowanie metody push dla stosu wartości typu double
   private static void testPushDouble(
      Stack<Double> stack, double[] values) {
      System.out.printf("%nUmieszczanie elementów w doubleStack%n");

      // Umieszczanie elementów na stosie
      for (double value : values) {
         System.out.printf("%.1f ", value);
         stack.push(value); // Wykonanie push dla doubleStack
      }
   }

   // Testowanie metody pop dla stosu wartości typu double
   private static void testPopDouble(Stack<Double> stack) {
      // Zdejmowanie elementów ze stosu
      try {
         System.out.printf("%nZdejmowanie elementów z doubleStack%n");
         double popValue; // Zapamiętanie elementu usuniętego ze stosu

         // Zdjęcie wszyskich elementów ze stosu
         while (true) {
            popValue = stack.pop(); // Wywołanie pop z doubleStack
            System.out.printf("%.1f ", popValue); 
         } 
      }
      catch(NoSuchElementException noSuchElementException) {
         System.err.println();
         noSuchElementException.printStackTrace();
      } 
   }

   // Testowanie metody push dla stosu wartości typu int
   private static void testPushInteger(
      Stack<Integer> stack, int[] values) {
      System.out.printf("%nUmieszczanie elementów w integerStack%n");

      // Umieszczanie elementów na stosie
      for (int value : values) {
         System.out.printf("%d ", value);
         stack.push(value); // Wykonanie push dla integerStack
      } 
   }

   // Testowanie metody pop dla stosu wartości typu int
   private static void testPopInteger(Stack<Integer> stack) {
      // Zdejmowanie elementów ze stosu.
      try {
         System.out.printf("%nZdejmowanie elementów z integerStack%n");
         int popValue; // Zapamiętanie elementu usuniętego ze stosu

         // Zdjęcie wszyskich elementów ze stosu
         while (true) {
            popValue = stack.pop(); // Wywołanie pop z intStack
            System.out.printf("%d ", popValue);
         } 
      } 
      catch(NoSuchElementException noSuchElementException) {
         System.err.println();
         noSuchElementException.printStackTrace();
      }
   } 
} 

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/