// Rysunek 16.3. ListTest.java
// Interfejsy i klasy List, LinkedList i ListIterator
import java.util.List;
import java.util.LinkedList;
import java.util.ListIterator;

public class ListTest {
   public static void main(String[] args) {
      // Dodaj elementy colors do list1
      String[] colors = 
         {"czarny", "żółty", "zielony", "niebieski", "fioletowy", "srebrny"};
      List<String> list1 = new LinkedList<>(); 

      for (String color : colors) {
         list1.add(color);
      }

      // Dodaj elementy colors2 do list2
      String[] colors2 = 
         {"złoty", "biały", "brązowy", "niebieski", "szary", "srebrny"};
      List<String> list2 = new LinkedList<>();

      for (String color : colors2) {
         list2.add(color);
      }

      list1.addAll(list2); // Połącz listy
      list2 = null; // Zwolnij zasoby
      printList(list1); // Wyświetl elementy list1

      convertToUppercaseStrings(list1); // Zamień na duże litery
      printList(list1); // Wyświetl elementy list1

      System.out.printf("%nUsuwanie elementów od 4 do 6...");
      removeItems(list1, 4, 7); // Usuń elementy od 4. do 6.
      printList(list1); // Wyświetl elementy list1
      printReversedList(list1); // Wyświetl elementy w odwrotnej kolejności
   }                                     

   // Wyświetl zawartość obiektu List
   private static void printList(List<String> list) {
      System.out.printf("%nlista:%n");
   
      for (String color : list) {
         System.out.printf("%s ", color);
      }

      System.out.println();
   }                                                    

   // Znajdź obiekty String i zamień je na duże litery
   private static void convertToUppercaseStrings(List<String> list) {
      ListIterator<String> iterator = list.listIterator();

      while (iterator.hasNext()) {
         String color = iterator.next(); // Pobierz element          
         iterator.set(color.toUpperCase()); // Zamień na duże litery
      } 
   } 

   // Pobierz podlistę i wywołaj metodę clear, aby usunąć elementy podlisty
   private static void removeItems(List<String> list, 
      int start, int end) {
      list.subList(start, end).clear(); // Usuń elementy
   } 

   // Wyświetl listę w odwrotnej kolejności
   private static void printReversedList(List<String> list) {
      ListIterator<String> iterator = list.listIterator(list.size());

      System.out.printf("%nOdwrócona lista:%n");

      // Wyświetl listę w odwrotnej kolejności
      while (iterator.hasPrevious()) {
         System.out.printf("%s ", iterator.previous()); 
      }
   } 
}



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
