// Rysunek 11.6. UsingExceptions.java
// Rozwijanie stosu i pobieranie danych z obiektu wyjątku

public class UsingExceptions {
   public static void main(String[] args) {
      try {
         method1();
      } 
      catch (Exception exception) { // Wychwycenie wyjątku zgłoszonego w method1
         System.err.printf("%s%n%n", exception.getMessage());
         exception.printStackTrace(); 

         // Pobranie informacji o wyjątku
         StackTraceElement[] traceElements = exception.getStackTrace();
         
         System.out.printf("%nZrzut stosu z getStackTrace:%n");
         System.out.println("Klasa\t\tPlik\t\t\tWiersz\tMetoda");

         // Przejście przez traceElements w celu pobrania szczegółów
         for (StackTraceElement element : traceElements) {
            System.out.printf("%s\t", element.getClassName());
            System.out.printf("%s\t", element.getFileName());
            System.out.printf("%s\t", element.getLineNumber());
            System.out.printf("%s%n", element.getMethodName());
         } 
      }
   } 

   // Wywołuje method2; przekazuje wyjątek do main
   public static void method1() throws Exception {
      method2();
   }

   // Wywołuje method3; przekazuje wyjątek do method1
   public static void method2() throws Exception {
      method3();
   } 

   // Zgłasza wyjątek do method2
   public static void method3() throws Exception {
      throw new Exception("Wyjątek zgłoszony w method3");
   } 
} 

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
