// Rysunek 10.12. Invoice.java
// Klasa Invoice implementująca Payable.

public class Invoice implements Payable {
   private final String partNumber; 
   private final String partDescription;
   private final int quantity;
   private final double pricePerItem;

   // Konstruktor.
   public Invoice(String partNumber, String partDescription, int quantity,
      double pricePerItem) {
      if (quantity < 0) { // Walidacja liczby sztuk.
         throw new IllegalArgumentException("Sztuki muszą być >= 0");
      }
      
      if (pricePerItem < 0.0) { // Walidacja ceny za sztukę.
         throw new IllegalArgumentException(
            "Cena za element musi być >= 0");
      }

      this.quantity = quantity;
      this.partNumber = partNumber;
      this.partDescription = partDescription;
      this.pricePerItem = pricePerItem;
   } 

   // Zwróć numer części.
   public String getPartNumber() {return partNumber;}

   // Zwróć opis.
   public String getPartDescription() {return partDescription;}

   // Zwróć liczbę sztuk.
   public int getQuantity() {return quantity;}

   // Zwróć cenę za element.
   public double getPricePerItem() {return pricePerItem;}

   // Zwróć tekstową reprezentację obiektu Invoice.
   @Override
   public String toString() {
      return String.format("%s: %n%s: %s (%s) %n%s: %d %n%s: %,.2f zł", 
         "faktura", "numer części", getPartNumber(), getPartDescription(),
         "sztuki", getQuantity(), "cena za element", getPricePerItem());
   } 

   // Metoda wymagana, aby spełnić kontrakt dotyczący interfejsu Payable.
   @Override                                                           
   public double getPaymentAmount() {                                  
      return getQuantity() * getPricePerItem(); // Oblicz łączną kwotę.
   }                                                                   
} 




/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
