// Rysunek 10.4. Employee.java
// Klasa abstrakcyjna Employee.

public abstract class Employee {
   private final String firstName;
   private final String lastName;
   private final String socialSecurityNumber;

   // Konstruktor.
   public Employee(String firstName, String lastName, 
      String socialSecurityNumber) {
      this.firstName = firstName;
      this.lastName = lastName;
      this.socialSecurityNumber = socialSecurityNumber;
   } 

   // Zwróć imię.
   public String getFirstName() {return firstName;}

   // Zwróć nazwisko.
   public String getLastName() {return lastName;}

   // Zwróć numer ubezpieczenia.
   public String getSocialSecurityNumber() {return socialSecurityNumber;}

   // Zwróć tekstową reprezentację obiektu Employee
   @Override
   public String toString() {
      return String.format("%s %s%nnumer ubezpieczenia: %s",
         getFirstName(), getLastName(), getSocialSecurityNumber());
   }

   // Metoda abstrakcyjna musi być skonkretyzowana w podklasie.
   public abstract double earnings(); // Nie ma implementacji.
} 



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
