// Rysunek 10.8. BasePlusCommissionEmployee.java
// Klasa BasePlusCommissionEmployee rozszerza klasę CommissionEmployee.

public class BasePlusCommissionEmployee extends CommissionEmployee {
   private double baseSalary; // Tygodniowe wynagrodzenie bazowe.

   // Konstruktor.
   public BasePlusCommissionEmployee(String firstName, String lastName, 
      String socialSecurityNumber, double grossSales,
      double commissionRate, double baseSalary) {
      super(firstName, lastName, socialSecurityNumber, 
         grossSales, commissionRate);

      if (baseSalary < 0.0) { // Walidacja baseSalary.
         throw new IllegalArgumentException("Wynagrodzenie bazowe musi być >= 0.0");
      }      
             
      this.baseSalary = baseSalary;                
   }

   // Ustaw wynagrodzenie bazowe.
   public void setBaseSalary(double baseSalary) {
      if (baseSalary < 0.0) { // Walidacja baseSalary.
         throw new IllegalArgumentException("Wynagrodzenie bazowe musi być >= 0.0");
      }
            
      this.baseSalary = baseSalary;                
   } 

   // Zwróć wynagrodzenie bazowe.
   public double getBaseSalary() {return baseSalary;}

   // Wylicz zarobek, przesłoń metodę z klasy CommissionEmployee.
   @Override
   public double earnings() {return getBaseSalary() + super.earnings();}

   // Zwróć tekstową reprezentację obiektu BasePlusCommissionEmployee.
   @Override                                                           
   public String toString() {                                          
      return String.format("%s %s; %s: %,.2f zł",                        
         "wynagradzany bazowo", super.toString(),
         "wynagrodzenie bazowe", getBaseSalary());
   }                                                                   
} 



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
