// Rysunek 5.9. LetterGrades.java
// Klasa LetterGrades używa instrukcji switch, aby zliczyć oceny literowe
import java.util.Scanner; 

public class LetterGrades {
   public static void main(String[] args) {
      int total = 0; // Suma ocen
      int gradeCounter = 0; // Liczba wpisanych ocen
      int aCount = 0; // Liczba ocen A
      int bCount = 0; // Liczba ocen B
      int cCount = 0; // Liczba ocen C
      int dCount = 0; // Liczba ocen D
      int fCount = 0; // Liczba ocen F

      Scanner input = new Scanner(System.in);

      System.out.printf("%s%n%s%n   %s%n   %s%n", 
         "Wpisz ocenę jako liczbę całkowitą z przedziału od 0 do 100.",
         "Wpisz znak końca pliku, aby zakończyć wpisywanie:",
         "W systemie UNIX/Linux/macOS wpisz <Ctrl> d i naciśnij Enter",
         "W systemie wpisz Windows <Ctrl> z i naciśnij Enter");

      // Przejdź w pętli aż do uzyskania informacji o końcu pliku
      while (input.hasNext()) {
         int grade = input.nextInt(); // Odczytaj ocenę
         total += grade; // Dodaj ocenę do sumy
         ++gradeCounter; // Zwiększ liczbę ocen
         
         // Zwiększ odpowiedni licznik dla liter
         switch (grade / 10) {                          
            case 9:  // Ocena od 90
            case 10: // do 100 włącznie
               ++aCount;                               
               break; // Zakończenie switch
            case 8: // Ocena od 80 do 89
               ++bCount;                               
               break; // Zakończenie switch
            case 7: // Ocena od 70 do 79
               ++cCount;                               
               break; // Zakończenie switch
            case 6: // Ocena od 60 do 69
               ++dCount;                               
               break; // Zakończenie switch
            default: // Ocena mniejsza niż 60
               ++fCount;                               
               break; // Opcjonalne; i tak zakończy switch
         }                                             
      }  

      // Wyświetlenie raportu
      System.out.printf("%nRaport z ocenami:%n");

      // Jeśli użytkownik wpisał choć jedną ocenę...
      if (gradeCounter != 0) {
         // Oblicz średnią wszystkich ocen
         double average = (double) total / gradeCounter;  

         // Wyświetl podsumowanie
         System.out.printf("Suma %d ocen wynosi %d%n",
            gradeCounter, total);
         System.out.printf("Średnia klasy wynosi %.2f%n", average);
         System.out.printf("%n%s%n%s%d%n%s%d%n%s%d%n%s%d%n%s%d%n", 
            "Liczba studentów, którzy otrzymali poszczególne oceny:",
            "A: ", aCount,  // Wyświetl liczbę ocen A
            "B: ", bCount,  // Wyświetl liczbę ocen B
            "C: ", cCount,  // Wyświetl liczbę ocen C
            "D: ", dCount,  // Wyświetl liczbę ocen D
            "F: ", fCount); // Wyświetl liczbę ocen F
      }
      else { // Nie wpisano ocen, więc wyświetl odpowiednią informację
         System.out.println("Nie wpisano ocen.");
      } 
   }
} 



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
