// Rysunek 23.25. FibonacciNumbersController.java
// Wykorzystanie obiektu Task do wykonywania
// długich obliczeń poza wątkiem aplikacji JavaFX
import java.util.concurrent.Executors;
import java.util.concurrent.ExecutorService;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;

public class FibonacciNumbersController {
   @FXML private TextField numberTextField;
   @FXML private Button goButton;
   @FXML private Label messageLabel;
   @FXML private Label fibonacciLabel;
   @FXML private Label nthLabel;
   @FXML private Label nthFibonacciLabel;

   private long n1 = 0; // Inicjalizacja ciągu Fibonacciego dla liczby 0
   private long n2 = 1; // Inicjalizacja ciągu Fibonacciego dla liczby 1
   private int number = 1; // Wartość ciągu Fibonacciego do obliczenia

   // Uruchamia FibonacciTask w celu wykonywania obliczeń w tle
   @FXML
   void goButtonPressed(ActionEvent event) {
      // Pobierz liczbę, dla której wyliczyć należy wartość ciągu Fibonacciego 
      try {
         int input = Integer.parseInt(numberTextField.getText());

         // Utwórz, skonfiguruj i uruchom FibonacciTask
         FibonacciTask task = new FibonacciTask(input);

         // Wyświetllaj komunikaty zadań w messageLabel
         messageLabel.textProperty().bind(task.messageProperty());

         // Wyczyść fibonacciLabel, gdy zadanie startuje
         task.setOnRunning((succeededEvent) -> {
            goButton.setDisable(true);
            fibonacciLabel.setText(""); 
         });
         
         // Ustaw fibonacciLabel, gdy zadanie zakończy się sukcesem
         task.setOnSucceeded((succeededEvent) -> {
            fibonacciLabel.setText(task.getValue().toString());
            goButton.setDisable(false);
         });

         // Utwórz ExecutorService do zarządzania wątkami
         ExecutorService executorService = 
            Executors.newFixedThreadPool(1); // Pula o rozmiarze jednego wątku
         executorService.execute(task); // Uruchom zadanie
         executorService.shutdown();
      }
      catch (NumberFormatException e) {
         numberTextField.setText("Wpisz liczbę całkowitą");
         numberTextField.selectAll();
         numberTextField.requestFocus();
      }
   }

   // Oblicza następną wartość ciągu Fibonacciego
   @FXML
   void nextNumberButtonPressed(ActionEvent event) {
      // Wyświetl następną wartość ciągu Fibonacciego
      nthLabel.setText("Fibonacci dla " + number + ": ");
      nthFibonacciLabel.setText(String.valueOf(n2));
      long temp = n1 + n2;
      n1 = n2;
      n2 = temp;
      ++number;
   }
}


/**************************************************************************
* (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
* Pearson Education, Inc. All Rights Reserved.                           *
*                                                                        *
* DISCLAIMER: The authors and publisher of this book have used their     *
* best efforts in preparing the book. These efforts include the          *
* development, research, and testing of the theories and programs        *
* to determine their effectiveness. The authors and publisher make       *
* no warranty of any kind, expressed or implied, with regard to these    *
* programs or to the documentation contained in these books. The authors *
* and publisher shall not be liable in any event for incidental or       *
* consequential damages in connection with, or arising out of, the       *
* furnishing, performance, or use of these programs.                     *
*************************************************************************/
