// Rysunek 23.16. SynchronizedBuffer.java
// Synchronizacja dostępu do współdzielonych i modyfikowanych danych 
// za pomocą metod wait i notifyAll klasy Object
public class SynchronizedBuffer implements Buffer {
   private int buffer = -1; // Współdzielone przez wątki producenta i konsumenta
   private boolean occupied = false; 
   
   // Umieszczenie wartości w buforze
   @Override
   public synchronized void blockingPut(int value)
      throws InterruptedException {               
      // Jeśli nie ma pustych miejsc, umieść wątek w stanie oczekiwania
      while (occupied) {
         // Wyświetl informacje o wątku i buforze, a następnie zacznij czekać
         System.out.println("Producer próbuje zapisu."); // Tylko w celach demonstracyjnych
         displayState("Buffer jest pełny. Producer czeka."); // Tylko w celach demonstracyjnych
         wait();
      } 
        
      buffer = value; // Ustaw nową wartość bufora
        
      // Wskaż, że producent nie może zapamiętać innej wartości,
      // dopóki konsument nie pobierze aktualnej
      occupied = true;                                
        
      displayState("Producer zapisuje " + buffer); // Tylko w celach demonstracyjnych
      
      notifyAll(); // Poinformuj oczekujące wątki, aby weszły w stan działania
   } // Koniec metody blockingPut; zwolnienie blokady na SynchronizedBuffer
    
   // Zwróć wartość z bufora
   @Override
   public synchronized int blockingGet() throws InterruptedException {
      // Jeśli nie ma danych, umieść wątek w stanie oczekiwania
      while (!occupied) {
         // Wyświetl informacje o wątku i buforze, a następnie zacznij czekać
         System.out.println("Consumer próbuje odczytu."); // Tylko w celach demonstracyjnych
         displayState("Buffer jest pusty. Consumer czeka."); // Tylko w celach demonstracyjnych
         wait();
      } 

      // Wskaż, że producent może zapisać nową wartość, bo
      // konsument pobrał aktualną
      occupied = false;                                

      displayState("Consumer odczytuje " + buffer); // Tylko w celach demonstracyjnych
      
      notifyAll(); // Poinformuj oczekujące wątki, aby weszły w stan działania

      return buffer;
   } // Koniec metody blockingGet; zwolnienie blokady na SynchronizedBuffer
    
   // Wyświetl aktualną operację i stan bufora; tylko w celach demonstracyjnych
   private synchronized void displayState(String operation) {
      System.out.printf("%-40s%d\t\t%b%n%n", operation, buffer, occupied);
   } 
} 



/**************************************************************************
 * (C) Copyright 1992-2015 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/